package cn.smarthse.wqyy.model.param.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: DengJia
 * @Date: 2023/8/23
 * @Description:
 */

@Data
@ApiModel("卫企预约机构联系信息 Param")
@AllArgsConstructor
@NoArgsConstructor
public class WqyyOrganizationContactParam implements Serializable {

    private static final long serialVersionUID = 8286537177377442630L;
    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id")
    private Long id;

    /**
     * 机构id;wqyy_organization.id
     */
    @ApiModelProperty(value = "机构id;wqyy_organization.id")
    private Long organizationId;

    /**
     * 总负责人;0否1是
     */
    @ApiModelProperty(value = "总负责人;0否1是")
    private Boolean isMaster;

    /**
     * 联系人id
     */
    @ApiModelProperty(value = "联系人id")
    private Long contactId;

    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人")
    private String contact;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    private String phone;

    /**
     * 联系人负责区域id
     */
    @ApiModelProperty(value = "联系人负责区域id")
    private Long areaId;

    /**
     * 是否有效;0无效1有效
     */
    @ApiModelProperty(value = "是否有效;0无效1有效")
    private Boolean isValid;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value = "最后修改人ID")
    private String updatedBy;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;

    private Long currentLoginOrgId;

    private Long currentLoginAreaId;

    private Long currentLoginUserId;

    private List<Long> areaIdList;


    public WqyyOrganizationContactParam(Long id, Boolean isMaster, Long contactId, String contact, String phone, Long areaId) {
        this.id = id;
        this.isMaster = isMaster;
        this.contactId = contactId;
        this.contact = contact;
        this.phone = phone;
        this.areaId = areaId;
    }
}
