package cn.smarthse.wqyy.model.param.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: DengJia
 * @Date: 2023/8/23
 * @Description:
 */

@Data
@ApiModel("卫企预约机构体检范围 Param")
@NoArgsConstructor
@AllArgsConstructor
public class WqyyOrganizationCheckTypeParam implements Serializable {

    private static final long serialVersionUID = 5891258747279811172L;
    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id")
    private Long id;

    /**
     * 机构id;wqyy_organization.id
     */
    @ApiModelProperty(value = "机构id;wqyy_organization.id")
    private Long organizationId;

    /**
     * 体检范围;wqyy_zd_check_type.check_type
     */
    @ApiModelProperty(value = "体检范围;wqyy_zd_check_type.check_type")
    private Integer checkType;

    /**
     * 是否有效;0无效1有效
     */
    @ApiModelProperty(value = "是否有效;0无效1有效")
    private Boolean isValid;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value = "最后修改人ID")
    private String updatedBy;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;

    public WqyyOrganizationCheckTypeParam(Integer checkType) {
        this.checkType = checkType;
    }

    public WqyyOrganizationCheckTypeParam(Long id, Integer checkType) {
        this.id = id;
        this.checkType = checkType;
    }
}
