package cn.smarthse.wqyy.model.param.appointment;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import lombok.Data;

/**
 * @ClassName WqyyResponsivityParam
 * @Description 体检预约响应率统计参数
 * @Author 曾华川
 * @Date 2023年12月26日 15:02
 **/
@Data
public class WqyyResponsivityParam extends JqGridParam {

    private static final long serialVersionUID = -624798846597063315L;

    private Long searchAreaId;
    private Byte searchAreaLevel;
    private String areaName;

    private Long userAreaId;
    private Byte userAreaLevel;

    /**
     * 展示全部地市
     */
    private Boolean isCity = false;

    /**
     * 展示全部区县
     */
    private Boolean isCounty = false;

    /**
     * 是否市本级机构
     *      1、null或者""：查询全部机构；
     *      2、true：查询市本级机构；
     *      3、false：查询非市本级机构。
     */
    private Boolean onlyCityLevelOrg;
}
