package cn.smarthse.wqyy.model.param.appointment;

import cn.smarthse.wqyy.validator.annotation.TotalNumNotZero;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @ author Supw
 * @ since 2023/8/23 11:26
 */
@Data
public class PartOneParam implements java.io.Serializable{
    @ApiModelProperty(name = "appointmentId",value = "预约id（只有从后面返回第一步 重新点下一步时需要携带该参数）")
    private Long appointmentId;

    @ApiModelProperty(name = "type",value = "预约类型 (1-门诊,2-外检)")
//    @NotEmpty(message = "预约类型不能为空")
    private Integer type;
    @ApiModelProperty(name = "companyName",value = "企业名称")
    @NotEmpty(message = "预约信息不能为空")
    private String companyName;
    @ApiModelProperty(name = "companyAddress",value = "企业地址")
    @NotEmpty(message = "预约信息不能为空")
    private String companyAddress;
    @ApiModelProperty(name = "contactName",value = "企业联系人")
    @NotEmpty(message = "预约信息不能为空")
    private String contactName;
    @ApiModelProperty(name = "contactTel",value = "企业联系人电话")
    @NotEmpty(message = "预约信息不能为空")
    private String contactTel;
    @ApiModelProperty(name = "orgId",value = "体检机构id")
//    @NotEmpty
    private Long orgId;
    @ApiModelProperty(name = "orgCantactAreaId",value = "机构联系人区域")
//    @NotEmpty
    private Long orgCantactAreaId;
    @ApiModelProperty(name = "items",value = "体检人员信息")
    @TotalNumNotZero
    List<ItemInfo> items;
}
