package cn.smarthse.wqyy.model.param.appointment;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * @ author Supw
 * @ since 2023/8/23 11:30
 */
@Data
public class ItemInfo implements java.io.Serializable {

    private Long appointmentId;
    @ApiModelProperty(name = "phyType",value = "体检类型(1-岗前,2-在岗,3-离岗)")
    @NotEmpty(message = "体检类型不能为空")
    private Integer phyType;
    @ApiModelProperty(name = "totalNum",value = "体检人数")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer totalNum=0;
    @ApiModelProperty(name = "numberOfFc",value = "接触粉尘的人数")
    private Integer numberOfFc=0;
    @ApiModelProperty(name = "numberOfHxys",value = "接触化学因素的人数")
    private Integer numberOfHxys=0;
    @ApiModelProperty(name = "numberOfBen",value = "接触苯的人数")
    private Integer numberOfBen=0;
    @ApiModelProperty(name = "numberOfWlys",value = "接触物理因素的人数")
    private Integer numberOfWlys=0;
    @ApiModelProperty(name = "numberOfZs",value = "接触噪声的人数")
    private Integer numberOfZs=0;
    @ApiModelProperty(name = "numberOfOther",value = "接触其他危害因素的人数")
    private Integer numberOfOther=0;
}
