package cn.smarthse.wqyy.model.param.activation;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import lombok.Data;

@Data
public class WqyyActivationSearchParam extends JqGridParam {

    private static final long serialVersionUID = -146760312252995737L;

    private Long searchAreaId;
    private Byte searchAreaLevel;
    private String areaName;

    private Long userAreaId;
    private Byte userAreaLevel;

    private Integer isLogin;

    /**
     * 是否已经接入
     */
    private Integer isAccess;

    /**
     * 1:大于等于3天
     * 0:小于3天
     */
    private Integer disconnect;

    /**
     * 搜索时间
     */
    private String beginTimeStr;
    private String endTimeStr;

    /**
     * 是否市本级机构
     *      1、null或者""：查询全部机构；
     *      2、true：查询市本级机构；
     *      3、false：查询非市本级机构。
     */
    private Boolean onlyCityLevelOrg;

}
