package cn.smarthse.wqyy.model.param;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 体检机构举报信息表(WqyyComplaint)表实体类
 *
 * @author zhangxu
 * @since 2023-08-24 08:58:56
 */
@Data
@ApiModel(value = "体检机构举报信息表(WqyyComplaint)")
@SuppressWarnings("serial")
public class WqyyComplaintParam implements Serializable {


    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 投诉机构id
     */
    @ApiModelProperty(value = "投诉机构id")
    private Long complaintOrgId;
    private Long areaOrgId;
    private Byte areaOrgLevel;

    /**
     * 投诉机构名字
     */
    @TableField(exist = false)
    private String orgName;

    /**
     * 投诉企业(那个企业投诉的)
     */
    @ApiModelProperty(value = "投诉企业(那个企业投诉的)")
    private Long complaintCid;
    private Boolean onlyThisLevel;
    private Integer belongType;
    /**
     * 投诉企业名字
     */
    @TableField(exist = false)
    private String companyName;

    /**
     * 投诉类型
     */
    @ApiModelProperty(value = "投诉类型(见枚举类型 WqyyComplaintTypeEnum)")
    private Integer complaintType;

    /**
     * 投诉状态(1草稿，2待审核，3退回，4已审核，5禁用账号)
     */
    @ApiModelProperty(value = "投诉状态(1草稿，2待审核，3退回，4已审核，5禁用账号)")
    private Integer status;
    /**
     * 投诉列表查询来源是监管还是运维
     */
    @ApiModelProperty(value = "投诉列表查询来源(1监管2运维)")
    private Integer complaintQueryType;
    /**
     * 关键字
     */
    @ApiModelProperty(value = "关键字")
    private String keyword;

    /**
     *监督单位id
     */
    private Long supervisionUnitId;

    /**
     * 监督单位的TreePath
     */
    private String supervisionUnitTreePath;

    /**
     * true：按行政区划搜监督单位，然后把搜到的监督单位，下的所有机构显示出来。
     * false/null/不传：按照行政区划搜索机构。
     */
    private Boolean searchBySupervision;
}
