package cn.smarthse.wqyy.enums.complaint;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum WqyyComplaintTypeEnum {

    /**
     * 内容反馈
     */
    CONTENT_ZZMG(1,"有政治敏感信息"),
    CONTENT_BLHS(2,"有暴力色情信息"),
    CONTENT_NRQQ(3,"内容涉嫌侵权"),

    /**
     * 服务过程
     */
    SERV_TD(4,"服务态度投诉"),
    SERV_ZL(5,"服务质量投诉"),
    SERV_SB(6,"对设备的投诉"),
    SERV_TFSJ(7,"突发性事件的投诉")
    ;

    private final Integer code;
    private final String name;

    public static String getName(Integer value) {
        WqyyComplaintTypeEnum[] cycleEnums = values();
        for (WqyyComplaintTypeEnum cycleEnum : cycleEnums) {
            if (cycleEnum.code.equals(value)) {
                return cycleEnum.getName();
            }
        }
        return null;
    }
}
