package cn.smarthse.wqyy.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum WqyyStatusEnum {

    CG(1,"草稿"),
    DSH(2,"待审核"),
    TH(3,"退回"),
    YSH(4,"已审核"),
    JYZH(5,"下架")
    ;

    private final Integer code;
    private final String name;

    public static String getName(Integer value) {
        WqyyStatusEnum[] cycleEnums = values();
        for (WqyyStatusEnum cycleEnum : cycleEnums) {
            if (cycleEnum.code.equals(value)) {
                return cycleEnum.name();
            }
        }
        return null;
    }
}
