package cn.smarthse.wqyy.enums;


import lombok.AllArgsConstructor;
import lombok.Getter;


@Getter
@AllArgsConstructor
public enum WqyySourceEnum {

    Mobile((byte) 1,"移动端"),
    Supervise((byte) 2,"监管端"),
    Organization((byte) 3,"机构端"),
    Enterprise((byte) 4,"企业端"),
    Maintenance((byte) 5,"运维端")
    ;

    private final Byte source;
    private final String name;

    public static String getName(Byte source) {
        WqyySourceEnum[] cycleEnums = values();
        for (WqyySourceEnum cycleEnum : cycleEnums) {
            if (cycleEnum.source.equals(source)) {
                return cycleEnum.name();
            }
        }
        return null;
    }
}
