package cn.smarthse.wqyy.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum WqyyLogWorkModeEnum {

    ZLSH(1,"机构资料审核模块"),
    JBSH(2,"机构举报违约审核模块"),
    SJXJ(3,"机构上架下架模块")
    ;

    private final Integer code;
    private final String name;

    public static String getName(Integer value) {
        WqyyLogWorkModeEnum[] cycleEnums = values();
        for (WqyyLogWorkModeEnum cycleEnum : cycleEnums) {
            if (cycleEnum.code.equals(value)) {
                return cycleEnum.name();
            }
        }
        return null;
    }
}
