package cn.smarthse.wqyy.entity.wqyy;

import java.util.Date;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 卫企预约关键工作操作日志(WqyyWorkOperateLog)表实体类
 *
 * @author zhangxu
 * @since 2023-08-24 08:58:56
 */
@Data
@ApiModel(value = "卫企预约关键工作操作日志(WqyyWorkOperateLog)")
@Accessors(chain = true)
@SuppressWarnings("serial")
public class WqyyWorkOperateLog implements Serializable {

    private static final long serialVersionUID = 445456598792309011L;

    /**
     * ID
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "ID")
    private Long id;
    /**
     * 来源模块，见枚举类WqyyLogWorkModeEnum
     */
    @ApiModelProperty(value = "来源模块，见枚举类WqyyLogWorkModeEnum")
    private Integer workModule;
    /**
     * 来源业务ID
     */
    @ApiModelProperty(value = "来源业务ID")
    private Long workId;
    /**
     * 状态;(2待审核，3退回，4已审核)WqyyStatusEnum
     */
    @ApiModelProperty(value = "状态;(2待审核，3退回，4已审核)WqyyStatusEnum")
    private Integer workStatus;
    /**
     * 原因
     */
    @ApiModelProperty(value = "原因")
    private String reason;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;
    /**
     * 操作人
     */
    @ApiModelProperty(value = "操作人")
    private String operater;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private Long createBy;
    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;
    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value = "最后修改人ID")
    private Long updateBy;
    /**
     * 是否有效（0-无效，1-有效）
     */
    @ApiModelProperty(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;
    /**
     * 企业名称
     */
    @ApiModelProperty(value = "企业名称")
    private String companyName;
    /**
     * 企业id
     */
    @ApiModelProperty(value = "企业id")
    private Long cid;
}
