package cn.smarthse.wqyy.entity.wqyy;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 预约日程
 *
 * @TableName wqyy_schedule
 */
@TableName(value = "wqyy_schedule")
@Data
public class WqyySchedule implements Serializable {
    /**
     *
     */
    @TableId(value = "id")
    private Long id;

    /**
     * wqyy_organization的id
     */
    @TableField(value = "organization_id")
    private Long organizationId;

    /**
     * 日程日期
     */
    @TableField(value = "schedule_date")
    private Date scheduleDate;

    /**
     * 营业状态（1：正常 2：暂停 3：关闭）
     */
    @TableField(value = "business_status")
    private Integer businessStatus;

    /**
     * 创建人
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 最后修改人
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private Date updateDate;

    /**
     * 是否有效
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}