package cn.smarthse.wqyy.entity.wqyy;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 卫企预约机构联系信息
 * </p>
 *
 * @author DengJia
 * @since 2023-08-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class WqyyOrganizationContact implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.NONE)
    private Long id;

    /**
     * 机构id;wqyy_organization.id
     */
    private Long organizationId;

    /**
     * 总负责人;0否1是
     */
    private Boolean isMaster;

    /**
     * 联系人id
     */
    private Long contactId;

    /**
     * 联系人
     */
    private String contact;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 联系人负责区域id
     */
    private Long areaId;

    /**
     * 是否有效;0无效1有效
     */
    private Boolean isValid;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private String updatedBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;


}
