package cn.smarthse.wqyy.entity.wqyy;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: DengJia
 * @Date: 2023/9/14
 * @Description: 卫企预约机构审核信息表
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class WqyyOrganizationAudit implements Serializable {

    private static final long serialVersionUID = -357042852484515352L;
    /**
     * 主键id;主键id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 机构id
     */
    private Long orgId;

    /**
     * 统一社会信用代码
     */
    private String uscc;

    /**
     * 机构名称
     */
    private String organizationName;

    /**
     * 机构所在区域id
     */
    private Long areaId;

    /**
     * 机构详细机构地址
     */
    private String organizationAddress;

    /**
     * 是否总部;0否1是
     */
    private Boolean isMaster;

    /**
     * 总部id;wqyy_organization.id
     */
    private Long organizationMasterId;

    /**
     * 已服务企业数
     */
    private Integer servedEnterprises;

    /**
     * 机构分数
     */
    private BigDecimal organizationScore;

    /**
     * 营业时间;周一至周天逗号分隔 如1,2,3,4,5
     */
    private String openingTime;

    /**
     * 体检开始时间;例9:00
     */
    private String checkBeginTime;

    /**
     * 体检结束时间;例17:00
     */
    private String checkEndTime;

    /**
     * 采血开始时间;例9:00
     */
    private String bloodBeginTime;

    /**
     * 采血结束时间;例11:00
     */
    private String bloodEndTime;

    /**
     * 7天内是否可预约;0不可1可
     */
    @TableField(value = "apply_in_7_days")
    private Boolean applyIn7Days;

    /**
     * 是否可外出体检;0不可1可
     */
    private Boolean outCheck;

    /**
     * 机构简介
     */
    private String organizationIntro;

    /**
     * 机构列表缩略图;文件id
     */
    private String orgListImg;

    /**
     * 机构详情展示图;文件id逗号分隔
     */
    private String orgDetailImg;

    /**
     * 预约人数警戒线
     */
    @TableField(value = "forbidden_line_of_people")
    private Integer forbiddenLineOfPeople = 200;

    /**
     * 预约企业警戒线
     */
    @TableField(value = "forbidden_line_of_enterprises")
    private Integer forbiddenLineOfEnterprises = 200;

    /**
     * 预约出车警戒线
     */
    @TableField(value = "forbidden_line_of_vehicles")
    private Integer forbiddenLineOfVehicles = 200;

    /**
     * 审核状态;(1草稿，2待审核，3退回，4已审核，5禁用账号)WqyyStatusEnum
     */
    private Byte auditStatus;

    /**
     * 是否有效;0无效1有效
     */
    private Boolean isValid;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private String updatedBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 操作记录提交时间
     */
    private Date operateCommitTime;

    @ApiModelProperty(value = "是否上下架：0下架，1上架")
    private Integer isShelves;
}
