package cn.smarthse.wqyy.entity.wqyy;

import java.util.Date;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 体检机构举报信息表(WqyyComplaint)表实体类
 *
 * @author zhangxu
 * @since 2023-08-24 08:58:56
 */
@Data
@ApiModel(value = "体检机构举报信息表(WqyyComplaint)")
@SuppressWarnings("serial")
public class WqyyComplaint implements Serializable {

    private static final long serialVersionUID = -93253614038294737L;

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 投诉机构id
     */
    @ApiModelProperty(value = "投诉机构id")
    private Long complaintOrgId;
    /**
     * 投诉企业(那个企业投诉的)
     */
    @ApiModelProperty(value = "投诉企业(那个企业投诉的)")
    private Long complaintCid;

    /**
     * 投诉类型
     */
    @ApiModelProperty(value = "投诉类型(见枚举类型 WqyyComplaintTypeEnum)")
    private Integer complaintType;
    /**
     * 投诉内容
     */
    @ApiModelProperty(value = "投诉内容")
    private String complaintContent;
    /**
     * 投诉状态(1草稿，2待审核，3退回，4已审核，5下架)WqyyStatusEnum
     */
    @ApiModelProperty(value = "投诉状态(1草稿，2待审核，3退回，4已审核，5下架) 见枚举类WqyyStatusEnum")
    private Integer status;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private Long createBy;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;
    /**
     * 最后修改人
     */
    @ApiModelProperty(value = "最后修改人")
    private Long updateBy;
    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;
    /**
     * 是否有效
     */
    @ApiModelProperty(value = "是否有效")
    private Boolean isValid;
}
