package cn.smarthse.wqyy.entity.wqyy;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 卫企预约-预约信息子表
 *
 * @TableName wqyy_appointment_item
 */
@TableName(value = "wqyy_appointment_item")
@Data
public class WqyyAppointmentItem implements Serializable {
    /**
     *
     */
    @TableId(value = "id")
    private Long id;

    /**
     *
     */
    @TableField(value = "appointment_id")
    private Long appointmentId;

    /**
     * 体检类型
     */
    @TableField(value = "phy_type")
    private Integer phyType;

    /**
     * 接触粉尘的人数
     */
    @TableField(value = "total_num")
    private Integer totalNum;


    /**
     * 接触粉尘的人数
     */
    @TableField(value = "number_of_fc")
    private Integer numberOfFc;

    /**
     * 接触化学因素的人数
     */
    @TableField(value = "number_of_hxys")
    private Integer numberOfHxys;

    /**
     * 接触苯的人数
     */
    @TableField(value = "number_of_ben")
    private Integer numberOfBen;

    /**
     * 接触物理因素的人数
     */
    @TableField(value = "number_of_wlys")
    private Integer numberOfWlys;

    /**
     * 接触噪声的人数
     */
    @TableField(value = "number_of_zs")
    private Integer numberOfZs;

    /**
     * 接触其他危害因素的人数
     */
    @TableField(value = "number_of_other")
    private Integer numberOfOther;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @TableField(value = "create_by" ,fill = FieldFill.INSERT)
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date" ,fill = FieldFill.INSERT)
    private Date createDate;

    /**
     * 最后修改者
     */
    @TableField(value = "update_by",fill = FieldFill.INSERT_UPDATE)
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date",fill = FieldFill.INSERT_UPDATE)
    private Date updateDate;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}