package cn.smarthse.wqyy.entity.wqyy;

import cn.smarthse.common.util.DateUtils;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 卫企预约-预约信息表
 *
 * @TableName wqyy_appointment
 */
@TableName(value = "wqyy_appointment")
@Data
public class WqyyAppointment implements Serializable {
    /**
     *
     */
    @TableId(value = "id")
    private Long id;

    @TableField(value = "cid")
    private Long cid;

    @TableField(value = "unified_social_cc")
    private String unifiedSocialCc;

    /**
     * 预约类型
     */
    @TableField(value = "type")
    private Integer type;

    /**
     * 预约状态
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 企业名称
     */
    @TableField(value = "company_name")
    private String companyName;

    /**
     * 企业地址
     */
    @TableField(value = "company_address")
    private String companyAddress;

    /**
     * 企业联系人
     */
    @TableField(value = "contact_name")
    private String contactName;

    /**
     * 企业联系人电话
     */
    @TableField(value = "contact_tel")
    private String contactTel;

    /**
     * 体检机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 机构联系人id
     */
    @TableField(value = "org_cantact_area_id")
    private Long orgCantactAreaId;

    /**
     * 企业预约时间
     */
    @TableField(value = "appointment_date")
    private Date appointmentDate;

    /**
     * 机构变更体检时间
     */
    @TableField(value = "change_date")
    private Date changeDate;

    /**
     * 时间体检时间
     */
    @TableField(value = "phy_date")
    private Date phyDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @TableField(value = "create_by", fill = FieldFill.INSERT)

    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date", fill = FieldFill.INSERT)
    private Date createDate;

    /**
     * 最后修改者
     */
    @TableField(value = "update_by", fill = FieldFill.INSERT_UPDATE)
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date", fill = FieldFill.INSERT_UPDATE)
    private Date updateDate;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}