package cn.smarthse.wqyy.entity.sys;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 第三方机构-机构表(create by 邓力宾)
 *
 * @TableName third_organization
 */
@TableName(value = "third_organization")
@Data
public class ThirdOrganization implements Serializable {
    /**
     * 主键id
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 机构名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 法定代表人
     */
    @TableField(value = "legal_person")
    private String legalPerson;

    /**
     * 法定代表人电话
     */
    @TableField(value = "legal_person_phone")
    private String legalPersonPhone;

    /**
     * 联系人
     */
    @TableField(value = "contact_name")
    private String contactName;

    /**
     * 联系人电话
     */
    @TableField(value = "contact_phone")
    private String contactPhone;

    /**
     * 省份id
     */
    @TableField(value = "province_id")
    private Long provinceId;

    /**
     * 城市id
     */
    @TableField(value = "city_id")
    private Long cityId;

    /**
     * 区域id
     */
    @TableField(value = "area_id")
    private Long areaId;

    /**
     * 省份名称
     */
    @TableField(value = "province_name")
    private String provinceName;

    /**
     * 城市名称
     */
    @TableField(value = "city_name")
    private String cityName;

    /**
     * 区县名称
     */
    @TableField(value = "area_name")
    private String areaName;

    /**
     * 详细地址
     */
    @TableField(value = "address")
    private String address;

    /**
     * 1:检测评价机构 2:体检机构 4:诊断机构 6:培训机构 8:鉴定机构 10:第三方托管机构（只适用企业作为机构）
     */
    @TableField(value = "org_type")
    private Integer orgType;

    /**
     * 资质等级（检测评价机构才有该字段） 0：无， 1：甲， 2：乙， 3：丙
     */
    @TableField(value = "level")
    private Integer level;

    /**
     * 备案主管单位字典id (0表示无)
     */
    @TableField(value = "record_manage_unit_dic_id")
    private Long recordManageUnitDicId;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 创建人id（监管端登录用户id）
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private Date updateDate;

    /**
     * 最后修改人id(监管端或机构端登录用户id)
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 是否有效(逻辑删除)
     */
    @TableField(value = "is_valid")
    private Integer isValid;

    /**
     * 服务区域
     */
    @TableField(value = "service_areas")
    private String serviceAreas;

    /**
     * 单位网址(检测评价机构)
     */
    @TableField(value = "unit_web")
    private String unitWeb;

    /**
     * 主要负责人(检测评价机构)
     */
    @TableField(value = "principal")
    private String principal;

    /**
     * 主要负责人手机(检测评价机构)
     */
    @TableField(value = "principal_phone")
    private String principalPhone;

    /**
     * 资质证书编号(检测评价机构)
     */
    @TableField(value = "certificate_no")
    private String certificateNo;

    /**
     * 专业技术人员数(检测评价机构)
     */
    @TableField(value = "technicist_num")
    private Integer technicistNum;

    /**
     * 高级职称人数(检测评价机构)
     */
    @TableField(value = "high_technicist_num")
    private Integer highTechnicistNum;

    /**
     * 中级职称人数(检测评价机构)
     */
    @TableField(value = "middle_technicist_num")
    private Integer middleTechnicistNum;

    /**
     * 专业技术负责人(检测评价机构)
     */
    @TableField(value = "technology_principal")
    private String technologyPrincipal;

    /**
     * 专业技术负责人技术职称(检测评价机构)
     */
    @TableField(value = "technology_principal_title")
    private String technologyPrincipalTitle;

    /**
     * 专业技术负责人培训合格证证号(检测评价机构)
     */
    @TableField(value = "technology_principal_qualification_no")
    private String technologyPrincipalQualificationNo;

    /**
     * 质量控制负责人(检测评价机构)
     */
    @TableField(value = "quality_principal")
    private String qualityPrincipal;

    /**
     * 质量控制负责人技术职称(检测评价机构)
     */
    @TableField(value = "quality_principal_title")
    private String qualityPrincipalTitle;

    /**
     * 质量控制负责人培训合格证证号(检测评价机构)
     */
    @TableField(value = "quality_principal_qualification_no")
    private String qualityPrincipalQualificationNo;

    /**
     * 是否是测试机构,默认false
     */
    @TableField(value = "test_data")
    private Integer testData;

    /**
     * 监督单位
     */
    @TableField(value = "supervision_unit")
    private Long supervisionUnit;

    /**
     * 监督单位区域
     */
    @TableField(value = "supervision_area_id")
    private Long supervisionAreaId;

    /**
     * 所属集团企业id(集团版该字段有效)
     */
    @TableField(value = "cid")
    private Long cid;

    /**
     * 是否启用 默认 是
     */
    @TableField(value = "is_enable")
    private Integer is_enable;

    /**
     * 社会统一信用代码（体检机构）
     */
    @TableField(value = "credit_code")
    private String creditCode;

    /**
     * 能否开展外出职业健康检查（体检机构）
     */
    @TableField(value = "can_out_check")
    private Integer canOutCheck;

    /**
     * 机构类型多个","隔开(1:检测评价机构 2:体检机构 4:诊断机构 6:培训机构 8:鉴定机构 10:第三方托管机构（只适用企业作为机构）12:服务管家机构)
     */
    @TableField(value = "org_types")
    private String orgTypes;

    /**
     * 营业状态 更新时间
     */
    @TableField(value = "business_update_time")
    private Date businessUpdateTime;

    /**
     * 删除时间
     */
    @TableField(value = "delete_time")
    private Date deleteTime;

    /**
     * 被删除的机构，导入时填充又被恢复的时间
     */
    @TableField(value = "import_recover_time")
    private Date importRecoverTime;

    /**
     * 营业状态 1:正常 2:暂停 3:关闭
     */
    @TableField(value = "business_status")
    private Integer businessStatus;

    /**
     * 是否隐藏，默认false
     */
    @TableField(value = "hidden")
    private Integer hidden;

    /**
     * 是否列为可提供服务的机构(诸暨市独有)
     */
    @TableField(value = "zj_service_org")
    private Integer zjServiceOrg;

    /**
     * 删除原因
     */
    @TableField(value = "delete_reason")
    private String deleteReason;

    /**
     *
     */
    @TableField(value = "delete_reason_desc")
    private String deleteReasonDesc;

    /**
     * 企业id(将企业添加为托管机构时，该字段有效)
     */
    @TableField(value = "trusteeship_cid")
    private Long trusteeshipCid;

    /**
     * 机构来源（1 万达仓；3：注册；4：监管端服务管家机构备案导入 5：卫企预约）
     */
    @TableField(value = "org_source")
    private Integer orgSource;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}