package cn.smarthse.wqyy.entity.sys;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 企业信息
 *
 * @TableName company
 */
@TableName(value = "company")
@Data
public class Company implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * fullname企业名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 企业类型（1-用人单位,2-外包单位,3-用人兼外包单位）
     */
    @TableField(value = "company_type")
    private Integer companyType;

    /**
     * 是否是测试企业
     */
    @TableField(value = "is_test")
    private Boolean isTest;

    /**
     * 企业名称简称
     */
    @TableField(value = "short_name")
    private String shortName;

    /**
     * 上属公司（主管单位）
     */
    @TableField(value = "father_dept")
    private String fatherDept;

    /**
     * 成立时间
     */
    @TableField(value = "setting_time")
    private Date settingTime;

    /**
     * 统一社会信用代码
     */
    @TableField(value = "unified_social_cc")
    private String unifiedSocialCc;

    /**
     * 顺序码
     */
    @TableField(value = "seq")
    private Integer seq;

    /**
     * 信用代码状态（0默认， 2信用代码错误）
     */
    @TableField(value = "social_cc_state")
    private Integer socialCcState;

    /**
     * corp_tel 企业联系电话
     */
    @TableField(value = "company_contact_tel")
    private String companyContactTel;

    /**
     * corp_email 企业电子邮箱
     */
    @TableField(value = "company_contact_email")
    private String companyContactEmail;

    /**
     * 企业传真
     */
    @TableField(value = "company_contact_fax")
    private String companyContactFax;

    /**
     * corp_area_id 行政区域区编号
     */
    @TableField(value = "area_id")
    private Long areaId;

    /**
     * 监督单位
     */
    @TableField(value = "supervision_unit")
    private Long supervisionUnit;

    /**
     * 监督单位区域
     */
    @TableField(value = "supervision_area_id")
    private Long supervisionAreaId;

    /**
     * 企业注册地详址
     */
    @TableField(value = "register_address")
    private String registerAddress;

    /**
     * 企业注册地址邮编
     */
    @TableField(value = "register_post")
    private String registerPost;

    /**
     * corp_address 企业通讯地址
     */
    @TableField(value = "company_postal_adress")
    private String companyPostalAdress;

    /**
     * 工作产所地址（工作场所地址）
     */
    @TableField(value = "work_address")
    private String workAddress;

    /**
     * 注册类型
     */
    @TableField(value = "register_type")
    private Long registerType;

    /**
     * corp_type 行业分类（sys_param.param_code）
     */
    @TableField(value = "industry_category")
    private Long industryCategory;

    /**
     * 职业病危害风险分类（0-严重、1-较重、2-一般）
     */
    @TableField(value = "occupational_risk_classify")
    private Integer occupationalRiskClassify;

    /**
     * 在岗职工人数
     */
    @TableField(value = "staff_count")
    private Integer staffCount;

    /**
     * 接害人数（不重复计）
     */
    @TableField(value = "pickup_count")
    private Integer pickupCount;

    /**
     * 当年接害人数是否被监管判定(0-否，1-接害人数<3，2-接害人数≥3)
     */
    @TableField(value = "victims_identify")
    private Integer victimsIdentify;

    /**
     * 接害人数判断（null：无数据；1：接害人数<3；3：接害人数≥3）
     */
    @TableField(value = "is_show_victims")
    private Integer isShowVictims;

    /**
     * 主营营业收入（万元）
     */
    @TableField(value = "main_opera_income")
    private BigDecimal mainOperaIncome;

    /**
     * 注册资本
     */
    @TableField(value = "register_capital")
    private BigDecimal registerCapital;

    /**
     * 企业规模
     */
    @TableField(value = "scale")
    private String scale;

    /**
     * 企业年度产值
     */
    @TableField(value = "year_assets")
    private BigDecimal yearAssets;

    /**
     * 企业资产总值
     */
    @TableField(value = "total_assets")
    private BigDecimal totalAssets;

    /**
     * 法人代表姓名
     */
    @TableField(value = "legal_name")
    private String legalName;

    /**
     * 法人代表联系电话
     */
    @TableField(value = "legal_tel")
    private String legalTel;

    /**
     * 化学事故应急咨询服务电话
     */
    @TableField(value = "chemical_emergency_phone")
    private String chemicalEmergencyPhone;

    /**
     * 职业卫生负责人
     */
    @TableField(value = "occ_leader_sid")
    private Long occLeaderSid;

    /**
     * 职业卫生负责人联系电话
     */
    @TableField(value = "occ_leader_tel")
    private String occLeaderTel;

    /**
     * 职业卫生管理人员
     */
    @TableField(value = "occ_manager_name")
    private String occManagerName;

    /**
     * ְ管理人员手机号码
     */
    @TableField(value = "occ_manager_tel")
    private String occManagerTel;

    /**
     * 企业主要负责人
     */
    @TableField(value = "main_leader_name")
    private String mainLeaderName;

    /**
     * 负责人手机号码
     */
    @TableField(value = "main_leader_tel")
    private String mainLeaderTel;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 数据来源（CompanyDataSourceEnum约定）
     */
    @TableField(value = "data_source")
    private Integer dataSource;

    /**
     * 数据来源ID（原ID）
     */
    @TableField(value = "data_source_id")
    private String dataSourceId;

    /**
     * 企业logo url 地址
     */
    @TableField(value = "logo_file_url")
    private String logoFileUrl;

    /**
     * [平台字段]企业编号串扩展(社会统一信代码/登记号/组织代码)
     */
    @TableField(value = "corp_cc_extend")
    private String corpCcExtend;

    /**
     * 经度
     */
    @TableField(value = "lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField(value = "lat")
    private String lat;

    /**
     * 处罚次数
     */
    @TableField(value = "punish_num")
    private Integer punishNum;

    /**
     * 是否有被纳入分类监督企业过(0-否,1-是)
     */
    @TableField(value = "is_dec")
    private Boolean isDec;

    /**
     * 是否是今年分类监督企业(0-否,1-是)
     */
    @TableField(value = "is_dec_current_year")
    private Boolean isDecCurrentYear;

    /**
     * 是否申报(0-未申报,1-已申报)
     */
    @TableField(value = "is_report")
    private Boolean isReport;

    /**
     * 所属地区
     */
    @TableField(value = "belong_to_region")
    private Long belongToRegion;

    /**
     * 自查结果是否可靠(0-否,1-是)
     */
    @TableField(value = "is_reliable")
    private Boolean isReliable;

    /**
     * 是否存在放射性危害因素(0否，1是)
     */
    @TableField(value = "is_exist_radioactivity")
    private Boolean isExistRadioactivity;

    /**
     * 是否是监督对象
     */
    @TableField(value = "is_supervise")
    private Boolean isSupervise;

    /**
     * 特殊排序需求
     */
    @TableField(value = "spec_sort")
    private Integer specSort;

    /**
     * 优化查询使用-视图company_supervise_view中的结果
     */
    @TableField(value = "is_show_supervise")
    private Boolean isShowSupervise;

    /**
     * 记录去年四个来源的接害人数
     */
    @TableField(value = "last_year_pick_up_count")
    private String lastYearPickUpCount;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}