<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8" />
  <title>用人单位职业病危害因素接触情况一览表</title>
  <style>
    html,
    body {
      margin: 0;
      padding: 0;
    }

    .title {
      font-size: 16pt;
      font-weight: bold;
      line-height: 1.25;
      text-align: center;
    }

    .label {
      margin-bottom: 8px;
      font-size: 10.5pt;
      font-weight: bold;
    }

    .blod {
      font-weight: bold;
    }

    table {
      width: 100%;
      text-align: center;
      table-layout:fixed;
      word-wrap: break-word;
      word-break: break-all;
      border-collapse: collapse;
      border-spacing: 2px;
    }

    caption {
      font-size: 14pt;
      font-weight: bold;
      line-height: 1.5;
      text-align: center;
    }

    th {
      padding: 7px 5px;
      color: #444;
      background-color: #fff;
      border-style: solid;
      border-width: 0.75pt;
    }

    td {
      padding: 5px;
      height: 32px;
      border-style: solid;
      border-width: 0.75pt;
      box-sizing: border-box;
    }

    tbody td {
      font-size: 11pt;
    }

    pre {
      margin: 0;
      padding: 0;
      font-size: 11pt;
    }

    .text-lf {
      text-align: left;
    }

    .small {
      width: 5%;
      min-width: 24px;
    }

    .middle {
      width: 8%;
      min-width: 150px;
    }

    .large {
      width: 15%;
      min-width: 160px;
    }
  </style>
</head>

<body>
  <div class="title">用人单位职业病危害因素接触情况一览表</div>
  <div class="label">
    <span>单位名称：${comName!""}</span>
  </div>
  <table>
    <colgroup>
      <col class="small"></col>
      <col class="middle"></col>
      <col class="middle"></col>
      <col class="small"></col>
      <col class="large"></col>
      <col class="small"></col>
      <col class="small"></col>
      <col class="small"></col>
      <col class="middle"></col>
      <col class="small"></col>
      <col class="large"></col>
      <col class="middle"></col>
      <col class="middle"></col>
    </colgroup>
    <#--<thead>
      <tr>
        <th rowspan="2">序号</th>
        <th rowspan="2">车间</th>
        <th rowspan="2">工种/岗位</th>
        <th rowspan="2">定员</th>
        <th rowspan="2">职业病危害因素名称</th>
        <th colspan="6">职业病危害因素检测结果</th>
        <th rowspan="2">接触水平</th>
        <th rowspan="2">职业病危害因素性质</th>
      </tr>
      <tr>
        <th>C<sub>TWA</sub></th>
        <th>C<sub>STEL</sub></th>
        <th>C<sub>MAC</sub></th>
        <th>超限倍数</th>
        <th>噪声等效声级</th>
        <th>其他因素</th>
      </tr>
    </thead>-->
    <tbody>
    <tr>
      <th rowspan="2">序号</th>
      <th rowspan="2">车间</th>
      <th rowspan="2">工种/岗位</th>
      <th rowspan="2">定员</th>
      <th rowspan="2">职业病危害因素名称</th>
      <th colspan="6">职业病危害因素检测结果</th>
      <th rowspan="2">接触水平</th>
      <th rowspan="2">职业病危害因素性质</th>
    </tr>
    <tr>
      <th>C<sub>TWA</sub></th>
      <th>C<sub>STEL</sub></th>
      <th>C<sub>MAC</sub></th>
      <th>超限倍数</th>
      <th>噪声等效声级</th>
      <th>其他因素</th>
    </tr>
    <#list evDataList as evData>
      <tr>
        <td>${evData_index+1}</td>
        <td>${evData.workshop!"/"}</td>
        <td>${evData.workName!"/"}</td>
        <td>${evData.workNum!"/"}</td>
        <td>
          <#if evData.factorName?contains("₂")>
            ${evData.factorName?replace("₂", "<sub>2</sub>")}
          <#else>
            ${evData.factorName!"/"}
          </#if>
        </td>
        <td>${evData.ctwa!"/"}</td>
        <td>${evData.cstel!"/"}</td>
        <td>${evData.cmac!"/"}</td>
        <td>${evData.exceedLimit!"/"}</td>
        <td>${evData.noiseLevel!"/"}</td>
        <td>${evData.otherFactorValue!"/"}</td>

        <td>
            <#if (evData.checkTouchLevel ==1)>不符合</#if>
            <#if (evData.checkTouchLevel ==2)>符合</#if>
             <#if (evData.checkTouchLevel ==3)>/</#if>
      </td>
      <td>
        <#if (evData.factorNature ==1)>一般</#if>
        <#if (evData.factorNature ==2)>严重</#if>
      </td>
      </tr>
   </#list>
    </tbody>
      <tr>
        <td colspan="6">
          <table>
            <caption>用人单位职业病危害风险等级判定表</caption>
            <thead>
              <tr>
                <th>职业病危害因素性质</th>
                <th>接触水平</th>
                <th>接触人数</th>
                <th>风险等级</th>
                <th>风险等级判定</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td rowspan="2">一般</td>
                <td>符合</td>
                <td>${decisionVo.generalTotalStaffCount - decisionVo.generalOverStaffCount}</td>
                <td>${decisionVo.generalNotOverRiskLevel}</td>
                <td rowspan="4">${decisionVo.riskLevel}</td>
              </tr>
              <tr>
                <td>不符合</td>
                <td>${decisionVo.generalOverStaffCount}</td>
                <td>${decisionVo.generalOverRiskLevel}</td>
              </tr>
              <tr>
                <td rowspan="2">严重</td>
                <td>符合</td>
                <td>${decisionVo.seriousOverTotalStaffCount - decisionVo.seriousOverStaffCount}</td>
                <td>${decisionVo.seriousNotOverRiskLevel}</td>
              </tr>
              <tr>
                <td>不符合</td>
                <td>${decisionVo.seriousOverStaffCount}</td>
                <td>${decisionVo.seriousOverRiskLevel}</td>
              </tr>
              <tr></tr>
            </tbody>
          </table>
        </td>
        <td colspan="7" class="text-lf">
          <span class="blod">注：</span><span>①职业病危害因素名称和检测结果根据有效期内的用人单位职业病危害现状评价报告或定期检测与评价报告填写。</span>
          <br />
          <span>  ②CTWA为时间加权平均接触浓度；CSTEL为短时间接触浓度；C<sub>MAC</sub>为最高浓度；超限倍数为短时间接触浓度和时间加权平均容许浓度之间的比值。</span>
          <br />
          <span>  当同一岗位或地点具有多个检测结果时，应填报最高值。</span>
        </td>
      </tr>
    <tbody>
      <tr></tr>
    </tbody>
  </table>
</body>

</html>