/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.util;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.fwgj.provider.company.IThirdGjOrgCustomerProviderToCompany;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.bind.service.ISysUserBindService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.SecRole;
import cn.smarthse.modules.health.entity.sys.SecUserRole;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.service.base.company.role.ICompanyRoleRelationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISecRoleService;
import cn.smarthse.modules.health.service.sys.ISecUserRoleService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.web.enums.ThirdOrganizationProvince;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.AppConfigHolder;
import com.alibaba.dubbo.rpc.RpcContext;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserUtils.class);
    private static ISysUserService sysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);
    private static ISecUserRoleService secUserRoleService = (ISecUserRoleService)SpringContextHolder.getBean(ISecUserRoleService.class);
    private static ISecRoleService secRoleService = (ISecRoleService)SpringContextHolder.getBean(ISecRoleService.class);
    private static IStaffInfoService staffInfoService = (IStaffInfoService)SpringContextHolder.getBean(IStaffInfoService.class);
    private static ICompanyProvideByHSEService companyProvideByHSEService = (ICompanyProvideByHSEService)SpringContextHolder.getBean(ICompanyProvideByHSEService.class);
    private static ISysAreaProvideService sysAreaProvideService = (ISysAreaProvideService)SpringContextHolder.getBean(ISysAreaProvideService.class);
    private static ICompanyRoleRelationService companyRoleRelationService = (ICompanyRoleRelationService)SpringContextHolder.getBean(ICompanyRoleRelationService.class);
    private static IThirdGjOrgCustomerProviderToCompany thirdGjOrgCustomerProviderToCompany = (IThirdGjOrgCustomerProviderToCompany)SpringContextHolder.getBean(IThirdGjOrgCustomerProviderToCompany.class);
    private static ISysUserBindService sysUserBindService = (ISysUserBindService)SpringContextHolder.getBean(ISysUserBindService.class);
    private static RedisClient redisClient = (RedisClient)SpringContextHolder.getBean(RedisClient.class);
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    private static final String prefix = "smarthse:sessionId:";

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroPrincipal getPrincipal() {
        try {
            Subject subject = UserUtils.getSubject();
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            if (principal != null) {
                return principal;
            }
        }
        catch (UnavailableSecurityManagerException | InvalidSessionException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void reflushPrincipal(ShiroPrincipal principal) {
        UserUtils.getSubject().runAs((PrincipalCollection)new SimplePrincipalCollection((Object)principal, principal.getUsername()));
    }

    public static Session getSession() {
        try {
            Subject subject = UserUtils.getSubject();
            Session session = subject.getSession(false);
            if (session == null) {
                session = subject.getSession();
            }
            if (session != null) {
                return session;
            }
        }
        catch (InvalidSessionException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getIp() {
        Session session = UserUtils.getSession();
        return session == null ? null : session.getHost();
    }

    public static SysUser getCurrentUser() {
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            SysUser user;
            if (principal.getUserId() != null && principal.getSysUser() == null && (user = (SysUser)sysUserService.getById(principal.getUserId())) != null) {
                principal.setSysUser(user);
                return user;
            }
            return principal.getSysUser();
        }
        return null;
    }

    @Deprecated
    public static Company getCurrentCompany() {
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            Long cid = principal.getCid();
            return UserUtils.getDataCentreCompany(cid);
        }
        log.error("[UserUtils.getCurrentCompany]:\u6ca1\u6709\u767b\u5f55\u4fe1\u606f");
        return null;
    }

    public static CompanyBaseInfoModel getCurrentCompanyFromDataCenter() {
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            Long cid = principal.getCid();
            return companyProvideByHSEService.getCompanyById(cid);
        }
        log.error("[UserUtils.getCurrentCompanyFromDataCenter]:\u6ca1\u6709\u767b\u5f55\u4fe1\u606f");
        return null;
    }

    public static StaffInfo getLoginStaff() {
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            if (principal.getStaffId() != null && principal.getStaffInfo() == null) {
                StaffInfo staffInfoWithStaffBasicWorkById = staffInfoService.getStaffInfoWithStaffBasicWorkById(principal.getStaffId());
                principal.setStaffInfo(staffInfoWithStaffBasicWorkById);
                return staffInfoWithStaffBasicWorkById;
            }
            return principal.getStaffInfo();
        }
        return null;
    }

    public static Long getLoginStaffCompanyId() {
        ShiroPrincipal shiroPrincipal = UserUtils.getPrincipal();
        if (shiroPrincipal != null) {
            return shiroPrincipal.getCid();
        }
        return null;
    }

    public static Long getLoginStaffId() {
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getStaffId();
    }

    public static Long getCurrentUserId() {
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            return principal.getUserId();
        }
        return null;
    }

    public static Long getOrgId() {
        ShiroPrincipal shiroPrincipal = UserUtils.getPrincipal();
        if (shiroPrincipal != null) {
            return shiroPrincipal.getOrgId();
        }
        return null;
    }

    public static String getLoginStaffName() {
        StaffInfo staff = UserUtils.getLoginStaff();
        if (staff != null) {
            return staff.getStaffBasicInfo() == null ? null : staff.getStaffBasicInfo().getRealName();
        }
        return null;
    }

    public static SysUser getSysUserById(long id) {
        SysUser user = null;
        if (user == null) {
            user = (SysUser)sysUserService.getById(Long.valueOf(id));
            if (user == null) {
                return null;
            }
            user.setRoleList(UserUtils.getRoleList(user));
            user.setDataScope(UserUtils.getDataScope(user));
        }
        return user;
    }

    public static SysUser getByLoginName(String username) {
        SysUser user = null;
        if (user == null) {
            user = sysUserService.getUserByuserame(username);
            if (user == null) {
                return null;
            }
            user.setRoleList(UserUtils.getRoleList(user));
        }
        return user;
    }

    public static List<String> getRoleList(SysUser user) {
        List roleList = secUserRoleService.getListByUserId(user.getId());
        if (roleList != null && roleList.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (SecUserRole userRole : roleList) {
                SecRole role = (SecRole)secRoleService.getById(userRole.getSecRoleId());
                if (role == null) continue;
                list.add(role.getRolename());
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static SysUser getLiteSysUserById(long id) {
        SysUser user = null;
        if (user == null) {
            user = (SysUser)sysUserService.getById(Long.valueOf(id));
            if (user == null) {
                return null;
            }
            user.setRoleList(UserUtils.getLiteRoleList(user));
            user.setDataScope(UserUtils.getDataScope(user));
        }
        return user;
    }

    public static List<String> getLiteRoleList(SysUser user) {
        List roleList = secUserRoleService.getListByUserId(user.getId());
        if (roleList != null && roleList.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            roleIds.add(1L);
            roleIds.add(2L);
            List sysRoles = secRoleService.getListBycid(user.getCid(), roleIds);
            for (SecUserRole userRole : roleList) {
                for (SecRole sr : sysRoles) {
                    if (!sr.getId().equals(userRole.getSecRoleId())) continue;
                    if (sr.getId() == 2L) {
                        sr.setRolename("\u4e00\u822c\u7528\u6237");
                    }
                    list.add(sr.getRolename());
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean hasPermissionCode(String permissionCode) {
        if (StringUtils.isNotEmpty((String)permissionCode)) {
            boolean hasAnyPermission = false;
            Subject subject = UserUtils.getSubject();
            if (subject != null && subject.isPermitted(permissionCode.trim())) {
                hasAnyPermission = true;
            }
            return hasAnyPermission;
        }
        return false;
    }

    public static boolean hasRole(String roleCode) {
        Subject subject;
        return StringUtils.isNotEmpty((String)roleCode) && (subject = UserUtils.getSubject()) != null && subject.hasRole(roleCode.trim());
    }

    private static Integer getDataScope(SysUser user) {
        return 1;
    }

    public static void updateCurrentUser(SysUser user) {
    }

    public static void updateLoginStaffStaff(StaffInfo staff) {
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            principal.setStaffId(staff.getId());
        }
    }

    @Deprecated
    private static Company getDataCentreCompany(Long cid) {
        CompanyBaseInfoModel companyBaseInfoModel = companyProvideByHSEService.getCompanyById(cid);
        Company company = new Company();
        try {
            BeanUtils.copyProperties((Object)company, (Object)companyBaseInfoModel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        company.setId(companyBaseInfoModel.getCid());
        return company;
    }

    public static void startWebDataScope() {
        Long loginStaffId = UserUtils.getLoginStaffId();
        RpcContext context = RpcContext.getContext();
        context.setAttachment("_loginStaffId", "" + loginStaffId);
        String _orgIds = StringUtils.join(UserUtils.getPrincipal().getOrgIdList(), (String)",");
        context.setAttachment("_orgIds", _orgIds);
        Long orgId = UserUtils.getOrgId();
        String isActualize = AppConfigHolder.getConfig("isActualize");
        context.setAttachment("_isActualize", isActualize);
        context.setAttachment("_orgId", (String)(orgId == null ? "" : "" + orgId));
    }

    public static boolean isSuperAdmin() {
        return UserUtils.hasRole(Constants.SUPER_AMDIN);
    }

    public static boolean isProfessionalCompany() {
        String isActualize = AppConfigHolder.getConfig("isActualize");
        if ("true".equals(isActualize)) {
            return true;
        }
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            Long cid = principal.getCid();
            Boolean flag = companyRoleRelationService.hasProfessionalRole(cid);
            return flag;
        }
        return false;
    }

    public static boolean isLiteVersion() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        String lite = AppConfigHolder.getConfig("web.view.prefix");
        return StringUtils.isNotEmpty((String)lite) && (lite.contains("lite") || lite.contains("zj"));
    }

    public static boolean hasThirdOrganization() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        String isActualize = AppConfigHolder.getConfig("isActualize");
        if ("true".equals(isActualize)) {
            return false;
        }
        CompanyBaseInfoModel companyBaseInfoModel = companyProvideByHSEService.getCompanyById(cid);
        Long areaId = companyBaseInfoModel.getAreaId();
        if (areaId == null) {
            return false;
        }
        AreaModel area = sysAreaProvideService.getAreaById(areaId);
        return ThirdOrganizationProvince.isContains(area == null ? null : area.getProvinceId());
    }

    public static boolean isZhouShanCompany() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel companyBaseInfoModel = companyProvideByHSEService.getCompanyById(cid);
        Long cityId = companyBaseInfoModel.getCityId();
        if (cityId == null) {
            return false;
        }
        return 330900000000L == cityId;
    }

    public static String entryptPassword(String plainPassword, String plainSalt) {
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = null;
        salt = StringUtils.isEmpty((CharSequence)plainSalt) ? Digests.generateSalt((int)8) : plainSalt.getBytes();
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        return Encodes.hexEncode((byte[])hashPassword);
    }

    public static boolean validatePassword(String plainPassword, String plainSalt, String password) {
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Encodes.hexDecode((String)plainSalt);
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        return password.equals(Encodes.hexEncode((byte[])hashPassword));
    }

    public static Long getCurCustomerId() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return thirdGjOrgCustomerProviderToCompany.getCurCustomerIdByCid(cid);
    }

    public static void hasBindInfo(SysUser currentUser) {
        if (currentUser == null) {
            return;
        }
        Long cid = currentUser.getCid();
        Serializable id = UserUtils.getSession().getId();
        boolean set = redisClient.set(prefix + cid.toString(), (Object)id, 3600000L);
        if (!set) {
            log.error("sessionId\u5b58\u50a8\u5931\u8d25");
        }
    }
}

