/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.util;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.leak.SSRFLeakUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.web.util.AppConfigHolder;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysFileUtil {
    private static ISysFileProvideService fileService = (ISysFileProvideService)SpringContextHolder.getBean(ISysFileProvideService.class);
    private static OssClientBean ossclient = (OssClientBean)SpringContextHolder.getBean(OssClientBean.class);
    private static final int CACHE_EXP = 0;
    public static final String CACHE_ITEMID_ = "sysfile_itemid_";
    protected static Logger logger = LoggerFactory.getLogger(SysFileUtil.class);

    public static SysFileModel getFileById(Long fileid) {
        SysFileModel file = null;
        if (file == null && (file = fileService.getSmartHseFileById(fileid)) == null) {
            return null;
        }
        return file;
    }

    public static String getFileUrlByfid(Long fileId) {
        if (fileId == null) {
            return null;
        }
        SysFileModel file = SysFileUtil.getFileById(fileId);
        if (file == null) {
            return "";
        }
        String ossurl = file.getDestPath();
        if (ossclient != null && ossclient.isAsynch()) {
            return ossclient.getUrl(ossurl);
        }
        String localPath = SysFileUtil.getLocalPath();
        return localPath + fileId;
    }

    private static String getLocalPath() {
        HttpServletRequest request = ServletsUtil.getRequest();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path;
        return basePath + "/" + ossclient.getAdminPath() + "/file/downloadLocal/";
    }

    public static String getContextPathFileUrlByfid(Long fileId) {
        if (fileId == null) {
            return null;
        }
        SysFileModel file = SysFileUtil.getFileById(fileId);
        if (file == null) {
            return "";
        }
        String ossurl = file.getDestPath();
        if (ossclient != null && ossclient.isAsynch()) {
            return ossclient.getUrl(ossurl);
        }
        HttpServletRequest request = ServletsUtil.getRequest();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path;
        return basePath + "/" + ossclient.getAdminPath() + "/file/downloadLocal/" + fileId;
    }

    public static InputStream getInputStreamFileUrlByfid(SysFileModel file, HttpServletRequest request) {
        InputStream is = null;
        try {
            if (file == null) {
                return null;
            }
            String ossurl = file.getDestPath();
            if (ossclient != null && ossclient.isAsynch()) {
                String ossFilePath = ossclient.getUrl(ossurl);
                if (!SSRFLeakUtil.securitySSRFFileTypeCheck((String)file.getFileExt(), (String)ossFilePath)) {
                    return null;
                }
                is = SysFileUtil.getFileInput(ossFilePath);
            } else {
                Object realPath = AppConfigHolder.getConfig("ossclient.ossdir");
                realPath = StringUtils.isBlank((CharSequence)realPath) ? request.getSession().getServletContext().getRealPath("/") : (String)realPath + File.separator;
                is = new FileInputStream((String)realPath + file.getDestPath());
            }
            return is;
        }
        catch (FileNotFoundException | MalformedURLException e) {
            e.printStackTrace();
            return is;
        }
    }

    public static InputStream getFileInput(String filePath) {
        InputStream iputstream = null;
        try {
            HttpResponse execute = HttpUtil.createGet((String)filePath).execute();
            iputstream = execute.bodyStream();
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u53d6\u5931\u8d25\uff01");
            return null;
        }
        return iputstream;
    }

    public static String getFileUrl(String ossurl) {
        if (StringUtils.isEmpty((CharSequence)ossurl)) {
            return null;
        }
        if (ossclient != null && ossclient.isAsynch()) {
            return ossclient.getUrl(ossurl);
        }
        HttpServletRequest request = ServletsUtil.getRequest();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path;
        return basePath + "/" + ossclient.getAdminPath() + "/file/downloadLocalByUrl?url=" + ossurl;
    }

    public static String getFileNameByfid(Long fileId) {
        if (fileId == null) {
            return null;
        }
        SysFileModel file = SysFileUtil.getFileById(fileId);
        if (file != null) {
            return file.getFileName();
        }
        return null;
    }

    public static void clearCache(Integer id) {
    }

    public static File getFileForTrainByfid(Long fileId) throws Exception {
        if (fileId == null) {
            return null;
        }
        SysFileModel file = SysFileUtil.getFileById(fileId);
        if (file == null) {
            return null;
        }
        String path = AppConfigHolder.getConfig("ossclient.ossdir");
        File dir = new File(path + File.separator + "train");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (ossclient != null && ossclient.isAsynch()) {
            return ossclient.downloadFileFromOss(file.getDestPath(), path, file.getFileName() + "." + file.getFileExt());
        }
        String localPath = path + File.separator + file.getDestPath();
        File localFile = new File(localPath);
        if (localFile.exists()) {
            File trainFile = new File(path + File.separator + "train" + File.separator + file.getFileName());
            if (!trainFile.exists()) {
                Files.copy(localFile.toPath(), trainFile.toPath(), new CopyOption[0]);
            }
            return trainFile;
        }
        return null;
    }

    public static File getFileByfid(Long fileId, String dirStr) throws Exception {
        if (fileId == null) {
            return null;
        }
        SysFileModel file = SysFileUtil.getFileById(fileId);
        if (file == null) {
            return null;
        }
        String path = AppConfigHolder.getConfig("ossclient.ossdir");
        File dir = new File(path + File.separator + dirStr);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (ossclient != null && ossclient.isAsynch()) {
            return ossclient.downloadFileFromOss(file.getDestPath(), path, file.getFileName());
        }
        String localPath = path + File.separator + file.getDestPath();
        File localFile = new File(localPath);
        if (localFile.exists()) {
            File trainFile = new File(path + File.separator + dirStr + File.separator + file.getFileName());
            if (!trainFile.exists()) {
                Files.copy(localFile.toPath(), trainFile.toPath(), new CopyOption[0]);
            }
            return trainFile;
        }
        return null;
    }
}

