/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.util;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearModulars;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearExecute;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearSyncSO;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearModularsService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncBusinessUtil {
    static IPlanYearDetailService planYearDetailService = (IPlanYearDetailService)SpringContextHolder.getBean(IPlanYearDetailService.class);
    static IPlanYearModularsService planYearModularsService = (IPlanYearModularsService)SpringContextHolder.getBean(IPlanYearModularsService.class);

    public static void syncBusinessWorkByPlanYear(PlanYear planYear) {
        if (planYear == null) {
            return;
        }
        if (planYear != null) {
            new AsyncBusinessThread((PlanYear)planYear.clone()).start();
        }
    }

    public static void executeUpdatePlanYearDetail(PlanYearExecute planYearExecute) {
        if (planYearExecute == null || planYearExecute.getCid() == null || StringUtils.isEmpty((CharSequence)planYearExecute.getBusinessType()) || planYearExecute.getBusinessId() == null || planYearExecute.getBusinessId() == 0L) {
            return;
        }
        PlanYearModulars planYearModulars = planYearModularsService.getByModularCode(planYearExecute.getBusinessType());
        if (planYearModulars == null) {
            return;
        }
        List list = planYearDetailService.getList(planYearExecute.getCid(), planYearModulars.getId(), planYearExecute.getBusinessId());
        for (PlanYearDetail detail : list) {
            if (planYearExecute.getImplState().getValue() == 2) {
                detail.setImplResult(Byte.valueOf(planYearExecute.getImplState().getValue()));
                planYearDetailService.update(detail);
                continue;
            }
            detail.setImplWorkName(planYearExecute.getImplWorkName());
            if (planYearExecute.getImplManagerId() != null) {
                detail.setImplManagerId(planYearExecute.getImplManagerId());
            } else {
                detail.setImplManagerId(detail.getManagerId());
            }
            detail.setImplStartDate(planYearExecute.getImplStartDate());
            detail.setImplEndDate(planYearExecute.getImplEndDate());
            detail.setImplResult(Byte.valueOf(planYearExecute.getImplState().getValue()));
            planYearDetailService.update(detail);
        }
    }

    public static class AsyncBusinessThread
    extends Thread {
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());
        private PlanYear planYear;

        public AsyncBusinessThread(PlanYear planYear) {
            this.planYear = planYear;
        }

        @Override
        public void run() {
            if (this.planYear != null) {
                this.logger.info(">>>>\u540c\u6b65\u5e74\u5ea6\u8be6\u7ec6\u8ba1\u5212\u300b\u300b\u300b\u300b\u3010\u5f00\u59cb\u3011 {}", (Object)DateUtils.formatDateTime((Date)new Date()));
                List detalList = planYearDetailService.getNoDecomposeListByPlanYearId(this.planYear.getId());
                PlanYearModulars planYearModulars = null;
                for (PlanYearDetail detail : detalList) {
                    if (detail.getBussnissId() != null && detail.getBussnissId() > 0L) continue;
                    planYearModulars = (PlanYearModulars)planYearModularsService.getById(detail.getBussnissModularId());
                    Long businessId = null;
                    PlanYearSyncSO detailSO = new PlanYearSyncSO(detail);
                    if (planYearModulars != null) {
                        detailSO.setWorkSubtype(detail.getWorkSubtype());
                        detailSO.setBusinesstype(planYearModulars.getModularCode());
                        detailSO.setBusinessBean(planYearModulars.getModularBean());
                    }
                    if (!StringUtils.isEmpty((CharSequence)detailSO.getBusinessBean())) {
                        IPlanYearWorkService planYearWorkService = null;
                        try {
                            planYearWorkService = (IPlanYearWorkService)SpringContextHolder.getBean((String)detailSO.getBusinessBean());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (planYearWorkService != null) {
                            businessId = planYearWorkService.syncAddPlanYearByBL(detailSO);
                        } else {
                            this.logger.error("Service Bean \u540d\u79f0\u672a\u5b9a\u4e49= [{}]\uff01\uff01\uff01", (Object)detailSO.getBusinessBean());
                        }
                    }
                    if (businessId == null || businessId == 0L) {
                        detail.setImplResult(Byte.valueOf(PlanYearDetailImplState.unimplemented.getValue()));
                        planYearDetailService.update(detail);
                    } else if (businessId != null && businessId > 0L) {
                        detail.setBussnissId(businessId);
                        detail.setImplResult(Byte.valueOf(PlanYearDetailImplState.progressing.getValue()));
                        planYearDetailService.update(detail);
                    }
                    planYearModulars = null;
                }
                this.logger.info(">>>>\u540c\u6b65\u5e74\u5ea6\u8be6\u7ec6\u8ba1\u5212\u300b\u300b\u300b\u300b\u3010\u7ed3\u675f\u3011{}", (Object)DateUtils.formatDateTime((Date)new Date()));
            } else {
                this.logger.error(">>>>\u540c\u6b65\u5e74\u5ea6\u8be6\u7ec6\u8ba1\u5212\u5f02\u5e38\u300b\u300b\u300b\u300bplanYear:{}", (Object)this.planYear);
            }
        }
    }
}

