/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.util;

import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.web.util.OrganizationUtil;
import cn.smarthse.web.util.UserUtils;
import java.util.List;

public class StaffUtil {
    private static IStaffInfoService staffService = (IStaffInfoService)SpringContextHolder.getBean(IStaffInfoService.class);
    private static final int CACHE_EXP = 7200;
    private static final String STAFF = "staffinfo_";

    public static StaffInfo getStaffDetailById(Long staffid) {
        if (staffid == null || staffid == 0L) {
            return null;
        }
        StaffInfo staff = null;
        if (staff == null && (staff = staffService.getStaffInfoWithStaffBasicWorkById(staffid)) == null) {
            return staff;
        }
        return staff;
    }

    public static String getStaffFullNameById(Long staffid) {
        if (staffid == null || staffid == 0L) {
            return null;
        }
        StaffInfo staff = StaffUtil.getStaffDetailById(staffid);
        if (staff == null) {
            return null;
        }
        if (staff.getStaffBasicInfo() == null) {
            return null;
        }
        StringBuffer organdname = new StringBuffer();
        if (!staff.getIsValid().booleanValue()) {
            organdname.append("(\u5df2\u5220\u9664)");
        }
        organdname.append(staff.getStaffBasicInfo().getRealName());
        return organdname.toString();
    }

    public static String getStaffNameOrgByStaffId(Long staffid) {
        CompanyOrganization org;
        if (staffid == null || staffid == 0L) {
            return null;
        }
        StaffInfo staff = StaffUtil.getStaffDetailById(staffid);
        if (staff == null) {
            return null;
        }
        if (staff.getStaffBasicInfo() == null) {
            return null;
        }
        StringBuffer organdname = new StringBuffer();
        if (staff.getStaffBasicWork() != null && staff.getStaffBasicWork().getOrgId() != null && staff.getStaffBasicWork().getOrgId() > 0L && (org = OrganizationUtil.getOrganizationById(staff.getStaffBasicWork().getOrgId())) != null) {
            organdname.append(org.getOrganizationName()).append("/");
        }
        if (!staff.getIsValid().booleanValue()) {
            organdname.append("(\u5df2\u5220\u9664)");
        }
        organdname.append(staff.getStaffBasicInfo().getRealName());
        return organdname.toString();
    }

    public static void clearCache(StaffInfo staff) {
        if (staff == null) {
            return;
        }
        StaffUtil.clearStaffById(staff.getId());
    }

    public static void clearStaffById(Long staffid) {
        if (staffid == null || staffid == 0L) {
            return;
        }
    }

    public static void clearCacheList(List<Long> ids) {
        if (ids == null) {
            return;
        }
        for (Long id : ids) {
            StaffUtil.clearStaffById(id);
        }
    }

    public static Integer getCountStaffByCid() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return staffService.getStaffInfoCountByCid(cid);
    }
}

