/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.util;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.web.util.AppConfigHolder;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginUtil.class);
    private static final String cachekey_loginFailMap = "loginFailMap";
    public static final String cachekey_loginCaptcha = "login_captcha";
    private static final String cachekey_MobileLoginVcode = "login_mobilevcode";
    protected static final String superCode = "supercode";
    private static volatile RedisClient redisClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisClient getRedisClient() {
        if (redisClient != null) return redisClient;
        Class<RedisClient> clazz = RedisClient.class;
        synchronized (RedisClient.class) {
            if (redisClient != null) return redisClient;
            redisClient = (RedisClient)SpringContextHolder.getBean(RedisClient.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisClient;
        }
    }

    public static boolean isValidateCodeLogin(String useruame, boolean isFail, boolean clean) {
        Integer loginFailNum = (Integer)LoginUtil.getRedisClient().get("loginFailMap:" + useruame);
        if (loginFailNum == null) {
            loginFailNum = 0;
        }
        if (isFail) {
            Integer n = loginFailNum;
            loginFailNum = loginFailNum + 1;
            LoginUtil.getRedisClient().set("loginFailMap:" + useruame, (Object)loginFailNum, 300L);
        }
        if (clean) {
            LoginUtil.getRedisClient().del(new String[]{"loginFailMap:" + useruame});
        }
        return loginFailNum >= Integer.valueOf(AppConfigHolder.getConfig("ehcache.loginFailCount"));
    }

    public static boolean isValidateCodeLoginFail(String useruame) {
        Integer loginFailNum = (Integer)LoginUtil.getRedisClient().get("loginFailMap:" + useruame);
        if (loginFailNum == null) {
            loginFailNum = 0;
        }
        return loginFailNum >= Integer.valueOf(AppConfigHolder.getConfig("ehcache.loginFailCount"));
    }

    public static String getLoginCaptcha() {
        return (String)LoginUtil.getRedisClient().get("login_captcha:" + String.valueOf(SecurityUtils.getSubject().getSession().getId()));
    }

    public static void setLoginCaptcha(String captcha) {
        Session session = SecurityUtils.getSubject().getSession();
        if (session != null) {
            LoginUtil.getRedisClient().set("login_captcha:" + String.valueOf(session.getId()), (Object)captcha, 60L);
        } else {
            log.error("\u8fd8\u6ca1\u6709\u521b\u5efa\u597d\u4f1a\u8bdd\u4fe1\u606f?...");
        }
    }

    public static boolean validate(HttpServletRequest request, String validateCode) {
        if (validateCode.equals(superCode)) {
            return true;
        }
        String code = LoginUtil.getLoginCaptcha();
        LoginUtil.getRedisClient().del(new String[]{"loginFailMap:" + String.valueOf(SecurityUtils.getSubject().getSession().getId())});
        boolean result = validateCode.toUpperCase().equals(code);
        if (!result) {
            log.error("\u9a8c\u8bc1\u7801\u9519\u8bef\u65e5\u5fd7\u8bb0\u5f55\uff1acode:{},validateCode:{} , sessionId:{}", new Object[]{code, validateCode, SecurityUtils.getSubject().getSession().getId()});
        }
        return result;
    }

    public static boolean validateMobileLoginVcode(String validateCode) {
        String vcode = (String)LoginUtil.getRedisClient().get("login_mobilevcode:" + String.valueOf(SecurityUtils.getSubject().getSession().getId()));
        return validateCode.equals(vcode);
    }
}

