/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.util;

import cn.smarthse.common.framework.easyExcel.EasyExcelNumberConvert;
import cn.smarthse.common.util.ServletsUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.cn.smarthse.modules.health.exception.HealthException;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportExcelUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ExportExcelUtils.class);

    public static void downloadByTemplate(String resultFileName, String templateFileName, Map<String, Object> datas, HttpServletResponse response, HttpServletRequest request) throws Exception {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)resultFileName, (HttpServletRequest)request);
            ExcelWriter excelWriter = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)out).registerConverter((Converter)new EasyExcelNumberConvert())).withTemplate(templateFileName).build();
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            excelWriter.fill(datas, writeSheet);
            excelWriter.finish();
        }
        catch (FileNotFoundException fe) {
            throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadByTemplate2(String resultFileName, String resultFilePath, String templateFileName, Map<String, Object> datas, HttpServletResponse response) throws Exception {
        XLSTransformer transformer = new XLSTransformer();
        try {
            FileInputStream is = new FileInputStream(templateFileName);
            HSSFWorkbook workBook = (HSSFWorkbook)transformer.transformXLS((InputStream)is, datas);
            FileOutputStream os = new FileOutputStream(resultFilePath);
            workBook.write((OutputStream)os);
            ((InputStream)is).close();
            os.flush();
            ((OutputStream)os).close();
        }
        catch (ParsePropertyException e) {
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage());
        }
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(resultFilePath));
        try {
            int bytesRead;
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(resultFileName.getBytes("GBK"), "ISO8859_1"));
            response.setContentType("application/octet-stream; charset=GBK");
            response.setHeader("Content-Length", String.valueOf(new File(resultFilePath).length()));
            byte[] buff = new byte[1024];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }
}

