/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesUtil {
    private static final Base64.Decoder decoder = Base64.getDecoder();
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final String ALGORITHM_STR = "AES/ECB/PKCS5Padding";
    private static final int GCM_TAG_LENGTH = 128;
    private static final int GCM_IV_LENGTH = 12;

    public static String encrypt(String aesKey, String srcStr) {
        try {
            if (aesKey.length() != 16 && aesKey.length() != 24 && aesKey.length() != 32) {
                throw new IllegalArgumentException("\u5bc6\u94a5\u957f\u5ea6\u5fc5\u987b\u4e3a 16\u300124 \u6216 32 \u5b57\u8282");
            }
            byte[] iv = new byte[12];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(iv);
            Cipher cipher = Cipher.getInstance(ALGORITHM_STR);
            SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey.getBytes(StandardCharsets.UTF_8), "AES");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKeySpec, gcmParameterSpec);
            byte[] encryptedBytes = cipher.doFinal(srcStr.getBytes(StandardCharsets.UTF_8));
            byte[] combined = new byte[iv.length + encryptedBytes.length];
            System.arraycopy(iv, 0, combined, 0, iv.length);
            System.arraycopy(encryptedBytes, 0, combined, iv.length, encryptedBytes.length);
            return encoder.encodeToString(combined);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String aesKey, String str) {
        try {
            if (aesKey.length() != 16 && aesKey.length() != 24 && aesKey.length() != 32) {
                throw new IllegalArgumentException("\u5bc6\u94a5\u957f\u5ea6\u5fc5\u987b\u4e3a 16\u300124 \u6216 32 \u5b57\u8282");
            }
            byte[] combined = decoder.decode(str);
            byte[] iv = new byte[12];
            System.arraycopy(combined, 0, iv, 0, iv.length);
            byte[] encryptedBytes = new byte[combined.length - iv.length];
            System.arraycopy(combined, iv.length, encryptedBytes, 0, encryptedBytes.length);
            Cipher cipher = Cipher.getInstance(ALGORITHM_STR);
            SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey.getBytes(StandardCharsets.UTF_8), "AES");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secretKeySpec, gcmParameterSpec);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

