/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.security.shiro;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.CookieUtil;
import cn.smarthse.common.util.ServletUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.limit.LoginLimitUtil;
import cn.smarthse.common.util.passwordLog.Md5Utils;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.SysUserTip;
import cn.smarthse.modules.health.service.sys.ISysLogService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.security.shiro.ShiroUsernamePasswordToken;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import com.sx.log.util.LogUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Reader;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class ShiroFormAuthenticationFilter
extends FormAuthenticationFilter {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String DEFAULT_CAPTCHA_PARAM = "validateCode";
    public static final String DEFAULT_MESSAGE_PARAM = "message";
    private final boolean twoFactorCheck;
    private String captchaParam = "validateCode";
    private String messageParam = "message";
    public static final String COOKIE_LOGIN_USERNAME = "account_cookie_username";
    public static String COOKIE_LOGIN_PASSWORD;
    public String COOKIE_LOGIN_PASSWORD_TO;
    private String isActualize;
    private ISysUserService sysUserService;
    private RedisClient redisClient;
    private RedissonClient redissonClient;
    private SessionDAO sessionDAO;
    private ISysLogService sysLogService;
    private IBigDataLogProviderService bigDataLogProviderService;
    private String appCode;
    private static final SerializeConfig config;

    private static SerializeConfig createSerializeConfig() {
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.configEnumAsJavaBean(new Class[]{ResponseStateEnum.class});
        return serializeConfig;
    }

    public ShiroFormAuthenticationFilter(boolean twoFactorCheck, String cookieLoginPassword, String isActualize, ISysUserService sysUserService, RedisClient redisClient, SessionDAO sessionDAO, ISysLogService sysLogService, IBigDataLogProviderService bigDataLogProviderService, String appCode, RedissonClient redissonClient) {
        this.twoFactorCheck = twoFactorCheck;
        COOKIE_LOGIN_PASSWORD = cookieLoginPassword;
        this.isActualize = isActualize;
        this.sysUserService = sysUserService;
        this.redisClient = redisClient;
        this.sessionDAO = sessionDAO;
        this.sysLogService = sysLogService;
        this.bigDataLogProviderService = bigDataLogProviderService;
        this.appCode = appCode;
        this.redissonClient = redissonClient;
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String body = null;
        try {
            body = IoUtil.read((Reader)request.getReader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject json = JSONUtil.parseObj((String)body);
        String username = json.getStr((Object)"username");
        String password = StringUtils.defaultString((String)json.getStr((Object)"password"), (String)"");
        String captcha = json.getStr((Object)DEFAULT_CAPTCHA_PARAM);
        boolean rememberMe = this.isRememberMe(request);
        String host = StringUtils.getRemoteAddr((HttpServletRequest)((HttpServletRequest)request));
        String cid = json.getStr((Object)"cid");
        String source = json.getStr((Object)"systemSource");
        Integer systemSource = StringUtils.isNotEmpty((String)source) ? Integer.parseInt(source) : UserSystemWideEnum.ZLWQ_COMPANY.getCode();
        this.logger.info("\u8868\u5355\u767b\u5f55\u8fc7\u6ee4\u5668\uff1a\uff1a\uff1ausername:{}, password:{}, host:{}, captcha:{}, cid:{}, rememberMe:{}, systemSource{} ", new Object[]{username, password, host, captcha, cid, rememberMe, systemSource});
        if (StringUtils.isNotEmpty((String)cid)) {
            return new ShiroUsernamePasswordToken(username, password.toCharArray(), rememberMe, host, systemSource, captcha, cid);
        }
        if (StringUtils.isNotEmpty((String)captcha)) {
            return new ShiroUsernamePasswordToken(username, password.toCharArray(), rememberMe, host, systemSource, captcha);
        }
        return new ShiroUsernamePasswordToken(username, password.toCharArray(), rememberMe, host, systemSource);
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getCaptchaParam());
    }

    protected String getCid(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)"cid");
    }

    public String getMessageParam() {
        return this.messageParam;
    }

    public String getSuccessUrl() {
        return super.getSuccessUrl();
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        String remoteIp;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpSession session = httpServletRequest.getSession();
        if (session != null) {
            session.removeAttribute("login_captcha");
        }
        ShiroUsernamePasswordToken r_token = (ShiroUsernamePasswordToken)token;
        SysUser loginUser = UserUtils.getCurrentUser();
        SysLog log = new SysLog();
        log.setTitle("\u767b\u5f55");
        log.setCompanyName(UserUtils.getCurrentCompany().getName());
        if (loginUser != null) {
            if (!StringUtils.sql_inj((String)loginUser.getUsername()).booleanValue()) {
                log.setUsername(loginUser.getUsername());
            }
            if (!StringUtils.sql_inj((String)loginUser.getFullname()).booleanValue()) {
                log.setFullname(loginUser.getFullname());
            }
            log.setCid(UserUtils.getLoginStaffCompanyId());
        }
        log.setCreateBy(UserUtils.getLoginStaffId());
        log.setUpdateBy(UserUtils.getLoginStaffId());
        log.setLogSource(Byte.valueOf(LogConstans.ENTERPRISE.getValue().byteValue()));
        log.setType(Byte.valueOf((byte)1));
        if (!StringUtils.sql_inj((String)httpServletRequest.getMethod()).booleanValue()) {
            log.setRequestMethod(httpServletRequest.getMethod());
        }
        if (!StringUtils.sql_inj((String)(remoteIp = StringUtils.getRemoteAddr((HttpServletRequest)httpServletRequest))).booleanValue()) {
            log.setRemoteIp(StringUtils.getRemoteAddr((HttpServletRequest)httpServletRequest));
        }
        if (!StringUtils.sql_inj((String)httpServletRequest.getRequestURI()).booleanValue()) {
            log.setRequestUri(httpServletRequest.getRequestURI());
        }
        log.setUserAgent(httpServletRequest.getHeader("user-agent"));
        log.setCreateDate(new Date());
        log.setUpdateDate(new Date());
        if (log.getIsValid() == null) {
            log.setIsValid(Global.TRUE);
        }
        ShiroPrincipal currentUser = UserUtils.getPrincipal();
        SysArea sysArea1 = currentUser.getSysArea();
        log.setSysArea(sysArea1);
        this.sysLogService.addLog(log);
        this.addBigDataLog(sysArea1.getId());
        if (!"true".equals(this.isActualize)) {
            Date lastLoginTime1 = loginUser.getLastLoginTime();
            if (lastLoginTime1 == null) {
                this.sysUserService.saveControlNotif(loginUser.getId(), Integer.valueOf(0));
            } else {
                SysUserTip userTip;
                LocalDate now = LocalDate.now();
                int monthValue = now.getMonthValue();
                int dayOfMonth = now.getDayOfMonth();
                int year = now.getYear();
                if (monthValue == 1 && dayOfMonth == 1 && ((userTip = this.sysUserService.getControlNotifByUserId(loginUser.getId())) == null || userTip.getControlNotifYear() == null || userTip.getControlNotifYear() != year)) {
                    this.sysUserService.saveControlNotif(loginUser.getId(), Integer.valueOf(0));
                }
            }
        }
        this.sysUserService.updateLastLoginTime(loginUser.getId());
        try {
            CookieUtil.setCookie((HttpServletResponse)httpServletResponse, (String)COOKIE_LOGIN_USERNAME, (String)URLEncoder.encode(r_token.getUsername(), "utf-8"), (int)31536000);
            CookieUtil.setCookie((HttpServletResponse)httpServletResponse, (String)"system.module.identification", (String)"smarthse-web", (int)31536000);
            CookieUtil.setCookie((HttpServletResponse)httpServletResponse, (String)"uid", (String)loginUser.getId().toString(), (int)31536000);
        }
        catch (Exception lastLoginTime1) {
            // empty catch block
        }
        if (!"XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("X-Requested-With"))) {
            this.issueSuccessRedirect(request, response);
        } else {
            HashMap<String, Object> result = new HashMap<String, Object>();
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            result.put("checkVcode", principal.getCheckVcode());
            result.put("username", DesensitizationUtils.name((String)loginUser.getUsername()));
            result.put("bindTel", DesensitizationUtils.desensitized((CharSequence)principal.getBindTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
            result.put("bindName", DesensitizationUtils.name((String)principal.getBindName()));
            result.put("fullname", DesensitizationUtils.name((String)loginUser.getFullname()));
            this.returnMsg((ResponseData<Object>)new ResponseData(ResponseStateEnum.success, "\u767b\u5f55\u6210\u529f", result), httpServletResponse);
        }
        return false;
    }

    private void addBigDataLog(Long regionId) {
        Long userId = UserUtils.getCurrentUserId();
        UserRoleEnum userRole = UserRoleEnum.ENTERPRISE_TYPE;
        String areaCode = null;
        if (regionId != null) {
            String regionIdStr = Convert.toStr((Object)regionId);
            areaCode = regionIdStr.length() > 9 ? regionIdStr.substring(0, 9) : regionIdStr;
        }
        this.bigDataLogProviderService.handleBigDataLog(ActionTypeEnum.LOGIN_TYPE, userRole, "", userId, areaCode, this.appCode);
        LogUtils.login((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        String className = ((Object)((Object)e)).getClass().getName();
        String message = "";
        this.logger.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)className);
        e.printStackTrace();
        String username = (String)token.getPrincipal();
        String keyName = "smarthse-web" + Md5Utils.hash((String)username);
        AtomicInteger atomicInteger = (AtomicInteger)this.redisClient.get(keyName);
        if (atomicInteger == null) {
            String nullUserKeyname = keyName + "-nulluser";
            this.redisClient.incr(nullUserKeyname, 1L);
            RAtomicLong atomicLong = this.redissonClient.getAtomicLong(nullUserKeyname);
            atomicLong.expire(1800L, TimeUnit.SECONDS);
            atomicInteger = new AtomicInteger((int)atomicLong.get());
            if (atomicLong.get() >= 5L) {
                className = LockedAccountException.class.getName();
            }
        }
        if (atomicInteger != null && atomicInteger.get() == 3) {
            message = "\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef3\u6b21\uff0c\u82e5\u518d\u9519\u8bef2\u6b21\uff0c\u60a8\u7684\u8d26\u53f7\u5c06\u4f1a\u88ab\u9501\u5b9a30\u5206\u949f\uff0c\u5efa\u8bae\u60a8\u8054\u7cfb\u5ba2\u670d(0571-89978771/89978775)\u8fdb\u884c\u5bc6\u7801\u91cd\u7f6e";
        } else if (IncorrectCredentialsException.class.getName().equals(className) || UnknownAccountException.class.getName().equals(className)) {
            message = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.";
        } else if (AuthenticationException.class.getName().equals(className)) {
            message = StringUtils.replace((String)e.getMessage(), (String)"msg:", (String)"");
        } else if (e.getMessage() != null && StringUtils.startsWith((CharSequence)e.getMessage(), (CharSequence)"msg:")) {
            message = StringUtils.replace((String)e.getMessage(), (String)"msg:", (String)"");
        } else if (ExcessiveAttemptsException.class.getName().equals(className)) {
            message = "\u5c1d\u8bd5\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
        } else if (LockedAccountException.class.getName().equals(className)) {
            message = "\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef5\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7b49\u5f8530\u5206\u949f\u518d\u5c1d\u8bd5\u767b\u5f55\uff0c\u5982\u6709\u7591\u95ee\u53ef\u8054\u7cfb\u5ba2\u670d\uff1a0571-89978771/89978775\u3002";
        } else {
            message = "\u7f51\u7edc\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01";
            this.logger.error("\u767b\u5f55\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        request.setAttribute(this.getFailureKeyAttribute(), (Object)className);
        request.setAttribute(this.getMessageParam(), (Object)message);
        return true;
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        Boolean aBoolean = LoginLimitUtil.loginRateLimit((ServletRequest)request, (ServletResponse)response);
        if (aBoolean.booleanValue()) {
            return super.executeLogin(request, response);
        }
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                return this.executeLogin(request, response);
            }
            return true;
        }
        Subject subject = this.getSubject(request, response);
        ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
        if (principal != null && (principal.getCheckVcode() == 0 || principal.getCheckVcode() == 2)) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            if (req.getHeader("x-requested-with") != null && req.getHeader("x-requested-with").equals("XMLHttpRequest")) {
                HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
                dataMap.put("checkVcode", principal.getCheckVcode());
                this.returnMsg((ResponseData<Object>)new ResponseData(ResponseStateEnum.success, "\u8bf7\u5148\u9a8c\u8bc1\u624b\u673a\u53f7", dataMap), res);
            } else {
                try {
                    WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)("/login?checkVcode=" + principal.getCheckVcode()));
                }
                catch (IOException e) {
                    this.logger.error("\u91cd\u5b9a\u5411\u5230\u9a8c\u8bc1\u624b\u673a\u53f7\u9875\u9762\u5931\u8d25", (Throwable)e);
                }
            }
            return false;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (req.getHeader("x-requested-with") == null || !req.getHeader("x-requested-with").equals("XMLHttpRequest")) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Attempting to access a path which requires authentication.  Forwarding to the Authentication url [" + this.getLoginUrl() + "]");
            }
            this.redirectToLogin(request, response);
            return false;
        }
        this.returnMsg((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED, "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01", (Object)ErrorEnum.HTTP_401.getHttpStatus()), res, ErrorEnum.HTTP_401.getHttpStatus());
        return false;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        Subject subject = this.getSubject(request, response);
        if ("/login".equals(servletRequest.getRequestURI()) && HttpMethod.POST.matches(servletRequest.getMethod()) && subject.isAuthenticated()) {
            this.logger.debug("\u5df2\u767b\u5f55\u7528\u6237\u91cd\u65b0\u53d1\u8d77\u767b\u5f55\u8bf7\u6c42\uff0c\u6267\u884c\u5f3a\u5236\u767b\u51fa");
            subject.logout();
        }
        if (subject.getPrincipal() == null && !subject.isRemembered()) {
            return false;
        }
        ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
        if (this.isTwoFactorCheck(principal)) {
            return false;
        }
        return super.isAccessAllowed(request, response, mappedValue) || !this.isLoginRequest(request, response) && this.isPermissive(mappedValue);
    }

    private boolean isTwoFactorCheck(ShiroPrincipal principal) {
        if (principal.getTwoFactorCheck() == 0) {
            return false;
        }
        return this.twoFactorCheck && (principal.getCheckVcode() == 0 || principal.getCheckVcode() == 2);
    }

    private void returnMsg(ResponseData<Object> data, HttpServletResponse response) {
        this.returnMsg(data, response, ErrorEnum.HTTP_200.getHttpStatus());
    }

    private void returnMsg(ResponseData<Object> data, HttpServletResponse response, int status) {
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(status);
        ServletUtils.renderString((HttpServletResponse)response, (String)JSON.toJSONString(data, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]));
    }

    static {
        config = ShiroFormAuthenticationFilter.createSerializeConfig();
    }
}

