/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.security.shiro;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.common.util.PropertiesLoader;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.passwordLog.Md5Utils;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.provider.IMicrocomCompanyYcqProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.bind.entity.SysUserBind;
import cn.smarthse.modules.health.bind.service.ISysUserBindService;
import cn.smarthse.modules.health.company.service.ICompanyPopupReminderService;
import cn.smarthse.modules.health.entity.base.company.CompanyCaseInfoParam;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.v3.SysMenuV3Vo;
import cn.smarthse.modules.health.entity.sys.vo.SecUserRoleVO;
import cn.smarthse.modules.health.enums.sys.PermissionDetailAreaEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.service.sys.ISecPermissionService;
import cn.smarthse.modules.health.service.sys.ISecUserRoleService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.security.shiro.ShiroUsernamePasswordToken;
import cn.smarthse.web.util.AesEncode;
import cn.smarthse.web.util.AppConfigHolder;
import cn.smarthse.web.util.LoginUtil;
import cn.smarthse.web.util.UserUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ShiroAuthorizingRealm
extends AuthorizingRealm {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @DubboReference
    IStaffInfoService staffService;
    @DubboReference
    ISecUserRoleService userRoleService;
    @DubboReference
    ICompanyOrganizationService organizationService;
    @DubboReference(version="1.0.0")
    ICompanyProvideService companyProvideService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    IStaffWorkRoleService staffWorkRoleService;
    @DubboReference
    ISysUserService sysUserService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private ILiteArchiveUpdateService archiveUpdateService;
    @Value(value="${isSharingSystem}")
    private Boolean isSharingSystem;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RedisClient redisClient;
    @DubboReference
    private ICompanyPopupReminderService companyPopupReminderService;
    @DubboReference
    private ISecPermissionService secPermissionService;
    @DubboReference
    private ISysUserBindService userBindService;
    @DubboReference(version="1.0.0")
    private IMicrocomCompanyYcqProvideService microcomCompanyYcqProvideService;
    @Resource
    protected HttpSession session;
    private static final Map<String, List<String>> SPECIAL_ORDER_MAP = Map.of("0E002002", List.of("0E002002001", "0E002002004", "0E002002002", "0E002002003"), "0E002008", List.of("0E002008001", "0E002008002", "0E002008003", "0E002008004", "0E002008005", "0E002008006"));

    public ShiroAuthorizingRealm() {
        this.setAuthenticationTokenClass(ShiroUsernamePasswordToken.class);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        ShiroPrincipal principal = (ShiroPrincipal)super.getAvailablePrincipal(principals);
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        SysUser user = UserUtils.getCurrentUser();
        if (user != null && principal.isAuthorized() == Global.FALSE.booleanValue()) {
            this.logger.debug("\u7528\u6237\u767b\u5f55\u540e\u521d\u59cb\u5316\u6743\u9650\u53ca\u89d2\u8272..........................");
            HashSet<String> authorities = new HashSet<String>();
            HashSet<String> rolelist = new HashSet<String>();
            this.setRoleAndPermissionList(principal.getUserId(), authorities, rolelist);
            Integer dataPermission = user.getDataScope();
            principal.setAuthorized(true);
            principal.setDataPermission(dataPermission);
            Set roleSet = this.secPermissionService.getRolePermission(user.getId());
            if (CollUtil.isEmpty((Collection)roleSet)) {
                this.secPermissionService.judgeAndInsertSysUserRoleV3(user.getId());
                roleSet = this.secPermissionService.getRolePermission(user.getId());
            }
            principal.setRoles(roleSet);
            principal.setAuthorities(this.secPermissionService.getMenuPermission(Integer.valueOf(3), user.getId()));
            List<SysMenuV3Vo> menuList = this.buildMenus(user, principal);
            ObjectMapper objectMapper = new ObjectMapper();
            String menuListJson = null;
            try {
                menuListJson = objectMapper.writeValueAsString(menuList);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            principal.setMenuListJson(menuListJson);
            this.logger.debug("\u7528\u6237\u3010{}\u3011\u6388\u6743\u521d\u59cb\u5316\u6210\u529f......", (Object)principal.getUsername());
            this.logger.debug("\u7528\u6237\u3010{}\u3011 \u89d2\u8272\u5217\u8868\u4e3a\uff1a{}", (Object)principal.getUsername(), rolelist);
            this.logger.debug("\u7528\u6237\u3010{}\u3011 \u6743\u9650\u5217\u8868\u4e3a\uff1a{}", (Object)principal.getUsername(), authorities);
            this.logger.debug("\u7528\u6237\u3010{}\u3011 \u6570\u636e\u8303\u56f4\u4e3a\uff1a{}", (Object)principal.getUsername(), (Object)dataPermission);
        }
        info.setStringPermissions(principal.getAuthorities());
        info.setStringPermissions(principal.getAuthorities());
        return info;
    }

    private void setRoleAndPermissionList(Long userId, Set<String> authorities, Set<String> rolelist) {
        String sysMenuPermission = "sys.menu";
        List userRoles = this.userRoleService.getUserRoleAndPermissionsByUserId(userId);
        if (userRoles == null) {
            return;
        }
        Long legalPermission = 113L;
        ArrayList<Long> excludePermissionIds = new ArrayList<Long>();
        excludePermissionIds.add(legalPermission);
        for (SecUserRoleVO userRole : userRoles) {
            String roleName = userRole.getRoleName();
            String permissionCode = userRole.getPermissionCode();
            if (StringUtils.isNotEmpty((String)roleName)) {
                rolelist.add(roleName);
            }
            if (StringUtils.isEmpty((CharSequence)permissionCode)) continue;
            authorities.add(permissionCode);
            if ("sys.user.view".equals(permissionCode)) {
                authorities.add(sysMenuPermission);
            } else if ("sys.role.view".equals(permissionCode)) {
                authorities.add(sysMenuPermission);
            } else if ("sys.permission.view".equals(permissionCode)) {
                authorities.add(sysMenuPermission);
            } else if ("sys.log.view".equals(permissionCode)) {
                authorities.add(sysMenuPermission);
            }
            Long permissionParentId = userRole.getParentId();
            String permiisionType = userRole.getPermissionType();
            if (this.hasAnyPermission(permissionParentId, PermissionDetailAreaEnum.base, excludePermissionIds, permiisionType)) {
                authorities.add("base.menu");
            }
            if (this.hasAnyPermission(permissionParentId, PermissionDetailAreaEnum.work, excludePermissionIds, permiisionType)) {
                authorities.add("work.menu");
            }
            if (!this.hasAnyPermission(permissionParentId, PermissionDetailAreaEnum.doc, excludePermissionIds, permiisionType)) continue;
            authorities.add("doc.menu");
        }
    }

    private boolean hasAnyPermission(Long parentPermissionId, PermissionDetailAreaEnum permissionDetailArea, List<Long> excludeIds, String permissionType) {
        String viewPermissionType = "2";
        if (excludeIds != null && excludeIds.contains(parentPermissionId)) {
            return false;
        }
        if (!viewPermissionType.equals(permissionType)) {
            return false;
        }
        return parentPermissionId >= permissionDetailArea.getMin() && parentPermissionId <= permissionDetailArea.getMax();
    }

    private void isRightLicense() {
        String isActualize = AppConfigHolder.getConfig("isActualize");
        if (!"true".equals(isActualize)) {
            return;
        }
        PropertiesLoader loader = new PropertiesLoader(new String[]{"License.dat"});
        try {
            String dueTime = loader.getProperty("Due.Time");
            Calendar now = Calendar.getInstance();
            Calendar calendar = Calendar.getInstance();
            String[] time = dueTime.split("-");
            int year = Integer.valueOf(time[0]);
            int month = Integer.valueOf(time[1]) - 1;
            int date = Integer.valueOf(time[2]);
            calendar.set(year, month, date, 0, 0, 0);
            if (calendar.before(now)) {
                throw new AuthenticationException("\u8f6f\u4ef6\u6388\u6743\u5df2\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u3002");
            }
            String licenseCode = loader.getProperty("License.Code");
            if (StringUtils.isLicenseRight((String)licenseCode, (String)dueTime)) {
                return;
            }
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AuthenticationException("\u8f6f\u4ef6\u6388\u6743\u7801\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u3002");
        }
        throw new AuthenticationException("\u8f6f\u4ef6\u6388\u6743\u7801\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u3002");
    }

    public boolean isRule(String str) {
        Pattern pattern = Pattern.compile(".*[0-9].*");
        boolean a = pattern.matcher(str).matches();
        pattern = Pattern.compile(".*[a-z].*");
        boolean b = pattern.matcher(str).matches();
        pattern = Pattern.compile(".*[A-Z].*");
        boolean c = pattern.matcher(str).matches();
        pattern = Pattern.compile(".*[!@#$%^&*].*");
        boolean d = pattern.matcher(str).matches();
        return a && b && c && d;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        Set roleSet;
        SysUserBind userBind;
        String username;
        SysUser user = null;
        boolean isRole = true;
        this.isRightLicense();
        ShiroUsernamePasswordToken token = (ShiroUsernamePasswordToken)authcToken;
        if (Objects.equals(4, token.getLoginType()) && Objects.nonNull(token.getCid())) {
            String cid = AesEncode.desEncrypt(token.getCid().trim());
            List userManager = this.sysUserService.getUserManager(Long.valueOf(cid.trim()));
            if (CollectionUtils.isNotEmpty((Collection)userManager)) {
                token.setUsername(((SysUser)userManager.get(0)).getUsername());
                if (token.getPassword() != null) {
                    String passWord = String.valueOf(token.getPassword());
                    passWord = AesEncode.desEncrypt(passWord).trim();
                    isRole = this.isRule(passWord);
                    String md5String = MD5Utils.getMD5String((String)passWord);
                    token.setPassword(md5String.toCharArray());
                }
            } else {
                throw new AuthenticationException("\u767b\u5f55\u9519\u8bef\uff1a\u8be5\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
            }
        }
        if (Objects.equals(2, token.getLoginType()) || Objects.equals(1, token.getLoginType())) {
            if (token.getUsername() != null) {
                username = AesEncode.desEncrypt(token.getUsername());
                token.setUsername(username.trim());
            }
            if (token.getPassword() != null) {
                String passWord = String.valueOf(token.getPassword());
                passWord = AesEncode.desEncrypt(passWord).trim();
                isRole = this.isRule(passWord);
                String md5String = MD5Utils.getMD5String((String)passWord);
                token.setPassword(md5String.toCharArray());
            }
        }
        if (StringUtils.isEmpty((CharSequence)(username = token.getUsername()))) {
            throw new AuthenticationException("\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a");
        }
        if (token.getLoginType() == 2 || token.getLoginType() == 4) {
            if (StringUtils.isEmpty((CharSequence)token.getCaptcha())) {
                throw new AuthenticationException("\u56fe\u5f62\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (LoginUtil.isValidateCodeLoginFail(username)) {
                throw new AuthenticationException("\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef\u8fc7\u591a, \u8bf7\u7b4910\u5206\u949f\u540e\u518d\u8bd5\uff01");
            }
            if (!LoginUtil.validate(ServletsUtil.getRequest(), token.getCaptcha())) {
                throw new AuthenticationException("\u9a8c\u8bc1\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.");
            }
        } else if (token.getLoginType() == 3) {
            if (StringUtils.isEmpty((CharSequence)token.getVcode())) {
                throw new AuthenticationException("\u52a8\u6001\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (LoginUtil.isValidateCodeLogin(token.getUsername(), false, false) && !LoginUtil.validateMobileLoginVcode(token.getVcode())) {
                throw new AuthenticationException("\u52a8\u6001\u9a8c\u8bc1\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.");
            }
        } else if (token.getLoginType() == 0) {
            this.logger.info("\u5355\u70b9\u767b\u9646\uff0cusername:{}", (Object)token.getUsername());
        }
        try {
            user = token.getUserId() != null ? UserUtils.getSysUserById(token.getUserId()) : UserUtils.getByLoginName(token.getUsername());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String keyName = "smarthse-web" + Md5Utils.hash((String)username);
        String nullUserKeyname = keyName + "-nulluser";
        RAtomicLong atomicLong = this.redissonClient.getAtomicLong(nullUserKeyname);
        if (atomicLong != null && atomicLong.get() >= 5L) {
            throw new LockedAccountException("\u8d26\u53f7\u88ab\u9501.");
        }
        if (user == null) {
            throw new AuthenticationException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.");
        }
        this.redisClient.del(new String[]{nullUserKeyname});
        if (user.getIsForbidden() != null && user.getIsForbidden().booleanValue()) {
            throw new AuthenticationException("\u767b\u5f55\u8d26\u53f7\u5df2\u88ab\u7981\u7528");
        }
        if (user.getCid() == null) {
            throw new AuthenticationException("\u8be5\u8d26\u53f7\u672a\u6388\u6743\uff0c\u8bf7\u786e\u8ba4\u4f01\u4e1a\u662f\u5426\u5728\u672c\u6b21\u5206\u7c7b\u7684\u6e05\u5355\u4e2d\u3002");
        }
        if (token.getLoginType() == 0) {
            user.setTwoFactorCheck(Byte.valueOf((byte)0));
        }
        user.setBindTel((userBind = this.userBindService.getByUserId(user.getId(), user.getCid(), UserSystemWideEnum.ZLWQ_COMPANY.getCode())) != null ? DesensitizationUtils.desensitized((CharSequence)userBind.getBindTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE) : null);
        user.setBindName(userBind != null ? DesensitizationUtils.name((String)userBind.getBindName()) : null);
        byte[] salt = Encodes.hexDecode((String)user.getSalt());
        ShiroPrincipal subject = new ShiroPrincipal(user);
        subject.setUserId(user.getId());
        subject.setFullName(user.getFullname());
        subject.setUsername(user.getUsername());
        subject.setCid(user.getCid());
        subject.setStaffId(user.getStaffId());
        subject.setLastLoginTime(user.getLastLoginTime());
        subject.setLoginSource(token.getLoginType());
        subject.setSharingSystem(this.isSharingSystem);
        subject.setTwoFactorCheck(user.getTwoFactorCheck());
        subject.setBindTel(userBind != null ? DesensitizationUtils.desensitized((CharSequence)userBind.getBindTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE) : null);
        subject.setBindName(userBind != null ? DesensitizationUtils.name((String)userBind.getBindName()) : null);
        if (!isRole || user.getIsDefaultPwd().booleanValue()) {
            subject.setDefaultPwd(true);
        } else {
            subject.setDefaultPwd(false);
        }
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(user.getCid());
        if (companyBaseInfoModel != null) {
            subject.setIsExistRadioactivity(companyBaseInfoModel.getIsExistRadioactivity());
            subject.setIsDec(companyBaseInfoModel.getIsDec());
            Integer dataSource = companyBaseInfoModel.getDataSource();
            Boolean isDec = companyBaseInfoModel.getIsDec();
            if (Objects.equals(CompanyDataSourceEnum.NEW_COMPANY_GUIDE.getValue(), dataSource) && Objects.equals(isDec, false)) {
                subject.setIsNewCompanyGuide(true);
            }
            String logoUrl = companyBaseInfoModel.getLogoFileUrl();
            String isActualize = AppConfigHolder.getConfig("isActualize");
            if ("true".equals(isActualize) || StringUtils.isBlank((CharSequence)logoUrl)) {
                HttpServletRequest request = ServletsUtil.getRequest();
                String path = request.getContextPath();
                String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path;
                subject.setCompanyLogoFileUrl(basePath + "/static/hse2.0/images/qylogo.png");
            }
            subject.setAreaId(companyBaseInfoModel.getAreaDetailId());
            SysArea area = new SysArea();
            AreaModel areaModel = this.sysAreaProvideService.getAreaById(companyBaseInfoModel.getAreaDetailId());
            BeanUtils.copyProperties((Object)areaModel, (Object)area);
            subject.setSysArea(area);
            Set<Byte> validScales = Set.of(Byte.valueOf((byte)3), Byte.valueOf((byte)4));
            if (UserSystemWideEnum.COMPANY_YC.getCode().equals(token.getSystemSource())) {
                Byte scale = this.microcomCompanyYcqProvideService.getMicrocomCompanyYcqScaleByCid(user.getCid());
                if (scale != null && validScales.contains(scale)) {
                    subject.setIsYcPro(true);
                }
            } else {
                subject.setIsYcPro(false);
            }
        }
        if (CollUtil.isEmpty((Collection)(roleSet = this.secPermissionService.getRolePermission(user.getId())))) {
            this.secPermissionService.judgeAndInsertSysUserRoleV3(user.getId());
            roleSet = this.secPermissionService.getRolePermission(user.getId());
        }
        subject.setRoles(roleSet);
        subject.setAuthorities(this.secPermissionService.getMenuPermission(Integer.valueOf(3), user.getId()));
        List<SysMenuV3Vo> menuList = this.buildMenus(user, subject);
        ObjectMapper objectMapper = new ObjectMapper();
        String menuListJson = objectMapper.writeValueAsString(menuList);
        subject.setMenuListJson(menuListJson);
        StaffInfo staffInfo = this.staffService.getStaffInfoWithStaffBasicWorkById(user.getStaffId());
        if (staffInfo != null && staffInfo.getStaffBasicInfo() == null) {
            this.logger.error("staff_basic_info\uff0c\u57fa\u7840\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (staffInfo != null && staffInfo.getStaffBasicInfo() != null) {
            subject.setFaceId(staffInfo.getStaffBasicInfo().getFaceId());
        }
        if (staffInfo != null && staffInfo.getStaffBasicWork() != null) {
            subject.setOrgId(staffInfo.getStaffBasicWork().getOrgId());
            List staffOrgs = this.staffWorkRoleService.getStaffOrgByStaffId(staffInfo.getId());
            if (CollectionUtils.isNotEmpty((Collection)staffOrgs)) {
                ArrayList<Long> orgIdList = new ArrayList<Long>();
                for (CompanyOrganization staffOrg : staffOrgs) {
                    if (staffOrg == null || staffOrg.getId() == null) continue;
                    Long orgId = staffOrg.getId();
                    List allChildrenCompanyOrganizationsByPid = this.organizationService.getAllChildrenCompanyOrganizationsByPid(orgId, user.getCid());
                    orgIdList.add(orgId);
                    if (!CollectionUtils.isNotEmpty((Collection)allChildrenCompanyOrganizationsByPid)) continue;
                    orgIdList.addAll(allChildrenCompanyOrganizationsByPid.stream().map(m -> m.getId()).collect(Collectors.toList()));
                }
                subject.setOrgIdList(orgIdList);
            }
        }
        SysUser finalUser = user;
        CompletableFuture.runAsync(() -> {
            try {
                this.archiveUpdateService.asyncRefreshArchiveV2(Arrays.asList(finalUser.getCid()), "201,301,404");
            }
            catch (Exception e) {
                this.logger.warn("\u5f02\u6b65\u5237\u65b0\u6863\u6848\u5931\u8d25: {}", (Object)e.getMessage());
            }
        });
        return new SimpleAuthenticationInfo((Object)subject, (Object)user.getPassword(), ByteSource.Util.bytes((byte[])salt), this.getName());
    }

    private List<SysMenuV3Vo> buildMenus(SysUser user, ShiroPrincipal principal) {
        Long cid = user.getCid();
        Long userId = user.getId();
        Boolean isNewCompany = null;
        Object isYcProjMicroCompany = null;
        if (principal.getIsNewCompany() == null) {
            isNewCompany = this.secPermissionService.judgeCurrentIsNewCompany(cid);
            principal.setIsNewCompany(isNewCompany);
        } else {
            isNewCompany = principal.getIsNewCompany();
        }
        if (StrUtil.isBlank((CharSequence)principal.getCompanyCase()) || CollUtil.isEmpty(principal.getCompanyCaseList())) {
            this.setCompanyCaseToPrincipal(principal);
        }
        CompanyCaseInfoParam param = new CompanyCaseInfoParam();
        param.setSystemWide(UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        param.setUserId(userId);
        param.setIsNewCompany(isNewCompany);
        param.setIsYcProjMicroCompany(principal.getIsYcPro());
        param.setIsExistRadioactivity(principal.getIsExistRadioactivity());
        param.setIsDec(principal.getIsDec());
        param.setCompanyCase(principal.getCompanyCase());
        param.setCompanyCaseList(principal.getCompanyCaseList());
        List menuList = this.secPermissionService.getSysMenuByUserId(param);
        LinkedHashMap menuMap = new LinkedHashMap();
        menuList.forEach(menu -> menuMap.put(menu.getMenuId(), menu));
        List returnMenuList = menuList.stream().filter(menu -> menu.getParentId() == 0L).collect(Collectors.toCollection(LinkedList::new));
        returnMenuList.forEach(menu -> this.addChildren((SysMenuV3Vo)menu, menuMap));
        this.sortMenuRecursive(returnMenuList);
        returnMenuList.sort(Comparator.comparing(SysMenuV3Vo::getOrderNum));
        return returnMenuList;
    }

    private void addChildren(SysMenuV3Vo menu, Map<Long, SysMenuV3Vo> menuMap) {
        if (menu.getChildren() == null) {
            menu.setChildren(new ArrayList());
        }
        for (SysMenuV3Vo child : menuMap.values()) {
            if (!Objects.equals(child.getParentId(), menu.getMenuId())) continue;
            menu.getChildren().add(child);
            this.addChildren(child, menuMap);
        }
    }

    private void sortMenuRecursive(List<SysMenuV3Vo> menuList) {
        if (CollUtil.isEmpty(menuList)) {
            return;
        }
        for (SysMenuV3Vo menu : menuList) {
            List children = menu.getChildren();
            if (!CollUtil.isNotEmpty((Collection)children)) continue;
            List<String> specialOrder = SPECIAL_ORDER_MAP.get(menu.getMenuCode());
            Comparator<SysMenuV3Vo> comparator = specialOrder != null ? Comparator.comparingInt(m -> {
                int idx = specialOrder.indexOf(m.getMenuCode());
                return idx == -1 ? Integer.MAX_VALUE : idx;
            }) : Comparator.comparing(SysMenuV3Vo::getOrderNum);
            children.sort(comparator);
            this.sortMenuRecursive(children);
        }
    }

    protected void assertCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) throws AuthenticationException {
        ShiroUsernamePasswordToken token = (ShiroUsernamePasswordToken)authcToken;
        if (token.getLoginType() == 0) {
            return;
        }
        super.assertCredentialsMatch((AuthenticationToken)token, info);
    }

    private void setCompanyCaseToPrincipal(ShiroPrincipal principal) {
        if (principal == null) {
            return;
        }
        Long cid = principal.getCid();
        ArrayList<String> companyCaseList = new ArrayList<String>();
        Long trainBaseCid = this.companyProvideService.judgeCompanyTrainingBaseByCid(cid);
        Long newCompanyCid = this.companyProvideService.judgeNewCompanyBetaByCid(cid);
        if (trainBaseCid != null) {
            companyCaseList.add("1");
        }
        if (newCompanyCid != null) {
            companyCaseList.add("2");
        }
        principal.setCompanyCase(companyCaseList.isEmpty() ? null : String.join((CharSequence)",", companyCaseList));
        principal.setCompanyCaseList(companyCaseList);
    }
}

