/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.security.shiro;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.passwordLog.Md5Utils;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroAuthorizingCredentialsMatcher
extends HashedCredentialsMatcher {
    private int retryCount = 3;
    private int retryFailCount = 10;
    private String passwordRetryCacheName = "passwordRetryCache";
    @Autowired
    private RedisClient redisClient;

    public static void main(String[] args) {
        String keyName = "smarthse-web" + Md5Utils.hash((String)"91330109MA2AYAT58N");
        System.out.println(keyName);
        keyName = "smarthse-web" + Md5Utils.hash((String)"\u5b8b\u6cf0\u5de5\u7a0b\u6280\u672f\uff08\u676d\u5dde\uff09\u6709\u9650\u516c\u53f8");
        System.out.println(keyName);
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        AtomicInteger retryAtomicCount;
        int currentCount;
        String username = (String)token.getPrincipal();
        String keyName = "smarthse-web" + Md5Utils.hash((String)username);
        Object retryCacheCount = this.redisClient.get(keyName);
        if (retryCacheCount == null) {
            retryCacheCount = new AtomicInteger(0);
            boolean addSuccess = this.redisClient.set(keyName, retryCacheCount, 1800L);
            System.out.println(addSuccess);
        }
        if ((currentCount = (retryAtomicCount = (AtomicInteger)retryCacheCount).incrementAndGet()) > this.retryCount) {
            throw new LockedAccountException();
        }
        boolean matches = super.doCredentialsMatch(token, info);
        if (matches) {
            this.redisClient.del(new String[]{keyName});
        } else {
            this.redisClient.set(keyName, retryCacheCount, 1800L);
            if (currentCount == this.retryCount) {
                throw new LockedAccountException();
            }
        }
        return matches;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryFailCount() {
        return this.retryFailCount;
    }

    public void setRetryFailCount(int retryFailCount) {
        this.retryFailCount = retryFailCount;
    }

    public String getPasswordRetryCacheName() {
        return this.passwordRetryCacheName;
    }

    public void setPasswordRetryCacheName(String passwordRetryCacheName) {
        this.passwordRetryCacheName = passwordRetryCacheName;
    }
}

