/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.loges;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.loges.LogProperties;
import cn.smarthse.common.util.loges.LogQueueProducer;
import cn.smarthse.common.util.loges.LogUtils;
import cn.smarthse.common.util.loges.SysRequestLog;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.web.util.UserUtils;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class WebRequestLogInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebRequestLogInterceptor.class);
    private static final String REQUESTSTARTTIME = "REQUESTSTARTTIME";
    @Autowired
    private LogQueueProducer logQueueProducer;
    @Value(value="${web.log.enabled:false}")
    private Boolean webLogEnabled;
    @Value(value="${web.log.logSource:0}")
    private Byte webLogLogSource;
    private static final ThreadLocal<SysRequestLog> logHolder = new ThreadLocal();
    private final Queue<SysRequestLog> logCacheQueue = new ConcurrentLinkedQueue<SysRequestLog>();
    private final AtomicInteger logCounter = new AtomicInteger(0);
    private static final int BATCH_SIZE = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        try {
            if (!(this.webLogEnabled.booleanValue() && LogProperties.ENABLED.booleanValue() && LogUtils.isLoggableRequest((HttpServletRequest)request))) {
                boolean bl = true;
                return bl;
            }
            SysRequestLog logDoc = new SysRequestLog();
            logDoc.setRemoteIp(LogUtils.getClientRealIp((HttpServletRequest)request));
            logDoc.setUserAgent(request.getHeader("User-Agent"));
            logDoc.setRequestUri(request.getRequestURI());
            logDoc.setRequestMethod(request.getMethod());
            logDoc.setOperateDate(new Date());
            SysUser currentUser = UserUtils.getCurrentUser();
            if (ObjectUtil.isNotNull((Object)currentUser)) {
                logDoc.setCid(currentUser.getCid());
                logDoc.setUsername(currentUser.getUsername());
                logDoc.setFullname(currentUser.getFullname());
            }
            logDoc.setLogSource(this.webLogLogSource);
            logHolder.set(logDoc);
            request.setAttribute(REQUESTSTARTTIME, (Object)System.currentTimeMillis());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u65e5\u5fd7\u5165\u961f\u5931\u8d25{}", (Throwable)e);
        }
        finally {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        try {
            if (!this.webLogEnabled.booleanValue()) {
            }
            if (!LogProperties.ENABLED.booleanValue()) {
            }
            if (!LogUtils.isLoggableRequest((HttpServletRequest)request)) {
            }
            SysRequestLog logDoc = logHolder.get();
            if (logDoc == null) {
            }
            long startTime = (Long)request.getAttribute(REQUESTSTARTTIME);
            logDoc.setConsumesTime(Long.valueOf(System.currentTimeMillis() - startTime));
            if (ex != null) {
                logDoc.setParams("Error: " + ex.getMessage());
            } else {
                logDoc.setParams(JsonMapper.toJsonString((Object)request.getParameterMap()));
            }
            this.logCacheQueue.offer(logDoc);
            if (this.logCounter.incrementAndGet() >= 500) {
                this.flushLogsToQueue();
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u65e5\u5fd7\u5165\u961f\u5931\u8d25{}", (Throwable)e);
        }
        finally {
            logHolder.remove();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushLogsToQueue() {
        SysRequestLog logDoc;
        if (this.logCacheQueue.isEmpty()) {
            return;
        }
        ArrayList<SysRequestLog> batchLogs = new ArrayList<SysRequestLog>(500);
        for (int drainedCount = 0; drainedCount < 500 && (logDoc = this.logCacheQueue.poll()) != null; ++drainedCount) {
            batchLogs.add(logDoc);
        }
        if (!batchLogs.isEmpty()) {
            try {
                this.logQueueProducer.addLogs(batchLogs);
            }
            catch (Exception e) {
                log.error("\u65e5\u5fd7\u63d0\u4ea4\u5931\u8d25\uff0c\u4e22\u5f03\u6570\u636e", (Throwable)e);
            }
            finally {
                this.logCounter.set(this.logCacheQueue.size());
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.flushLogsToQueue();
        log.error("\u65e5\u5fd7\u63d0\u4ea4\u672b\u5c3e\u5904\u7406");
    }
}

