/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.interprecetors;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@Component
public class WorkAddInterceptor
implements HandlerInterceptor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${isActualize}")
    private String isActualize;
    @Value(value="${adminPath}")
    protected String adminPath;
    @DubboReference
    IStaffWorkRoleService staffWorkRoleService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Long staffId;
        if (!this.isAddUrl(request)) {
            return true;
        }
        if (!"true".equals(this.isActualize)) {
            return true;
        }
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        SysUser loginUser = UserUtils.getCurrentUser();
        if (loginUser == null) {
            request.getRequestDispatcher(this.adminPath + "/login").forward((ServletRequest)request, (ServletResponse)response);
        }
        if ((staffId = UserUtils.getLoginStaffId()) == null) {
            request.getRequestDispatcher(this.adminPath + "/init/linkStaff").forward((ServletRequest)request, (ServletResponse)response);
            return false;
        }
        List staffOrgs = this.staffWorkRoleService.getStaffOrgByStaffId(staffId);
        if (!CollectionUtils.isEmpty((Collection)staffOrgs) && staffOrgs.size() > 1) {
            request.setAttribute("isShowStaffOrgs", (Object)true);
        }
        return true;
    }

    private boolean isAddUrl(HttpServletRequest request) {
        String nav = request.getServletPath();
        nav = nav.replaceAll("//", "/");
        String editParam = null;
        if (StringUtils.contains((CharSequence)nav, (CharSequence)"/work/pdmonitor/edit")) {
            editParam = request.getParameter("pdId");
        } else if (StringUtils.contains((CharSequence)nav, (CharSequence)"/work/scene/normal/edit")) {
            editParam = request.getParameter("inspectionId");
        } else if (StringUtils.contains((CharSequence)nav, (CharSequence)"/work/reform/editUnfinished")) {
            editParam = request.getParameter("reformId");
        } else {
            return true;
        }
        return !StringUtils.isNotEmpty((String)editParam);
    }
}

