/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.interprecetors;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.service.sys.ISysLogService;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.Optional;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LogInterceptor
implements HandlerInterceptor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference
    ISysLogService sysLogService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView != null) {
            this.logger.info("ViewName: " + modelAndView.getViewName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            if (handler instanceof HandlerMethod) {
                HandlerMethod methodHandler = (HandlerMethod)handler;
                Log log = methodHandler.getMethod().getAnnotation(Log.class);
                Long loginStaffId = UserUtils.getLoginStaffId();
                Long cid = UserUtils.getLoginStaffCompanyId();
                SysUser loginUser = UserUtils.getCurrentUser();
                if (log != null && loginUser != null) {
                    Optional<SysArea> sysArea = Optional.ofNullable(UserUtils.getPrincipal()).map(ShiroPrincipal::getSysArea);
                    SysLog syslog = new SysLog();
                    syslog.setSysArea(sysArea.get());
                    syslog.setUsername(loginUser.getUsername());
                    syslog.setFullname(loginUser.getFullname());
                    syslog.setTitle(log.title());
                    syslog.setCid(cid);
                    syslog.setCreateBy(loginStaffId);
                    syslog.setUpdateBy(loginStaffId);
                    syslog.setType(Byte.valueOf(log.type()));
                    boolean isSave = true;
                    if (ex == null) {
                        JsonMapper.toJsonString((Object)request.getParameterMap());
                        syslog.setParams(JsonMapper.toJsonString((Object)request.getParameterMap()));
                        if (StringUtils.isNotEmpty((String)log.noSaveWhere()) && StringUtils.isNotEmpty((String)syslog.getParams()) && syslog.getParams().contains(log.noSaveWhere())) {
                            isSave = false;
                        }
                    }
                    if (isSave) {
                        String remoteIp;
                        syslog.setLogSource(Byte.valueOf((byte)1));
                        if (!StringUtils.sql_inj((String)request.getMethod()).booleanValue()) {
                            syslog.setRequestMethod(request.getMethod());
                        }
                        if (!StringUtils.sql_inj((String)(remoteIp = StringUtils.getRemoteAddr((HttpServletRequest)request))).booleanValue()) {
                            syslog.setRemoteIp(StringUtils.getRemoteAddr((HttpServletRequest)request));
                        }
                        if (ex != null) {
                            syslog.setType(Byte.valueOf((byte)0));
                            StringBuffer errorStr = new StringBuffer();
                            errorStr.append(ex).append("<br/>");
                            for (StackTraceElement s : ex.getStackTrace()) {
                                errorStr.append(s.toString()).append("<br/>");
                            }
                            if (!StringUtils.sql_inj((String)errorStr.toString()).booleanValue()) {
                                syslog.setParams(errorStr.toString());
                            }
                            syslog.setIsValid(Boolean.valueOf(false));
                        }
                        if (!StringUtils.sql_inj((String)request.getRequestURI()).booleanValue()) {
                            syslog.setRequestUri(request.getRequestURI());
                        }
                        syslog.setUserAgent(request.getHeader("user-agent"));
                        syslog.setCreateDate(new Date());
                        syslog.setUpdateDate(new Date());
                        if (syslog.getIsValid() == null) {
                            syslog.setIsValid(Global.TRUE);
                        }
                        ShiroPrincipal currentUser = UserUtils.getPrincipal();
                        SysArea sysArea1 = currentUser.getSysArea();
                        syslog.setSysArea(sysArea1);
                        this.sysLogService.addLog(syslog);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
        }
    }
}

