/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.interprecetors;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.smarthse.common.util.ServletUtils;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.sys.annotation.PasswordLog;
import cn.smarthse.modules.sys.entity.SysOperLog;
import cn.smarthse.modules.sys.enumd.BusinessStatusEnum;
import cn.smarthse.modules.sys.enumd.BusinessTypeEnum;
import cn.smarthse.modules.sys.enumd.OperatorDataSourceEnum;
import cn.smarthse.web.util.AsyncFactory;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    public static final String[] EXCLUDE_PROPERTIES = new String[]{"password", "oldPassword", "newPassword", "confirmPassword"};
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;

    @Pointcut(value="@annotation(cn.smarthse.modules.sys.annotation.PasswordLog)")
    public void logPointCut() {
    }

    @AfterReturning(pointcut="@annotation(controllerPasswordLog)", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, PasswordLog controllerPasswordLog, Object jsonResult) {
        this.handleLog(joinPoint, controllerPasswordLog, null, jsonResult);
    }

    @AfterThrowing(value="@annotation(controllerPasswordLog)", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, PasswordLog controllerPasswordLog, Exception e) {
        this.handleLog(joinPoint, controllerPasswordLog, e, null);
    }

    protected void handleLog(JoinPoint joinPoint, PasswordLog controllerPasswordLog, Exception e, Object jsonResult) {
        try {
            SysOperLog operLog = new SysOperLog();
            operLog.setStatus(BusinessStatusEnum.SUCCESS.getValue());
            HttpServletRequest request = ServletUtils.getRequest();
            operLog.setOperIp(JakartaServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            operLog.setOperUrl(StringUtils.substring((String)ServletUtils.getRequest().getRequestURI(), (int)0, (int)255));
            operLog.setDataSource(OperatorDataSourceEnum.ENTERPRISE.getValue());
            SysUser currentUser = UserUtils.getCurrentUser();
            if (currentUser != null) {
                operLog.setCid(currentUser.getCid());
                operLog.setUserName(currentUser.getUsername());
                operLog.setOperName(currentUser.getUsername());
                operLog.setCreateBy(currentUser.getId());
            } else {
                String cid = (String)ServletUtils.getRequest().getAttribute("cid");
                String username = (String)ServletUtils.getRequest().getAttribute("username");
                operLog.setOperName(username);
                operLog.setUserName(username);
                if (StringUtils.isNotBlank((CharSequence)cid)) {
                    try {
                        operLog.setCid(Long.valueOf(Long.parseLong(cid)));
                    }
                    catch (NumberFormatException ex) {
                        log.warn("cid\u683c\u5f0f\u9519\u8bef: {}", (Object)cid);
                        operLog.setCid(null);
                    }
                } else {
                    operLog.setCid(null);
                }
            }
            if (e != null) {
                operLog.setStatus(BusinessStatusEnum.FAIL.getValue());
                operLog.setErrorMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)255));
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            operLog.setMethod(className + "." + methodName + "()");
            operLog.setRequestMethod(ServletUtils.getRequest().getMethod());
            this.getControllerMethodDescription(joinPoint, controllerPasswordLog, operLog, jsonResult);
            if (StrUtil.contains((CharSequence)String.valueOf(jsonResult), (CharSequence)"\u4e0d\u53ef\u4f7f\u7528\u5386\u53f2\u5bc6\u7801\u6216\u521d\u59cb\u5bc6\u7801")) {
                operLog.setStatus(BusinessStatusEnum.FAIL.getValue());
            }
            this.taskExecutor.execute((Runnable)AsyncFactory.recordOper(operLog));
        }
        catch (Exception exp) {
            log.error("==\u524d\u7f6e\u901a\u77e5\u5f02\u5e38==");
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
    }

    public void getControllerMethodDescription(JoinPoint joinPoint, PasswordLog passwordLog, SysOperLog operLog, Object jsonResult) throws Exception {
        operLog.setBusinessType(passwordLog.businessType().getValue());
        operLog.setDataOf(passwordLog.dataOf().getValue());
        operLog.setTitle(passwordLog.title());
        if (passwordLog.isSaveRequestData()) {
            this.setRequestValue(joinPoint, operLog, passwordLog);
        }
        if (passwordLog.isSaveResponseData() && ObjectUtil.isNotNull((Object)jsonResult)) {
            operLog.setJsonResult(StringUtils.substring((String)JSONObject.toJSONString((Object)jsonResult), (int)0, (int)255));
        }
    }

    private void setRequestValue(JoinPoint joinPoint, SysOperLog operLog, PasswordLog passwordLog) {
        Map map = ServletUtils.getRequest().getParameterMap();
        if (CollUtil.isNotEmpty((Map)map)) {
            String[] stringArray;
            int n;
            int n2;
            String[] fullnames;
            SysUser sysUser;
            String params = JSONObject.toJSONString((Object)map, (SerializeFilter)this.excludePropertyPreFilter(), (SerializerFeature[])new SerializerFeature[0]);
            operLog.setOperParam(StringUtils.substring((String)params, (int)0, (int)255));
            if (Objects.equals(passwordLog.businessType().getValue(), BusinessTypeEnum.CHANGEPASSWORD.getValue()) && (sysUser = (SysUser)((ISysUserService)SpringContextHolder.getBean(ISysUserService.class)).getById(UserUtils.getCurrentUserId())) != null && !sysUser.getIsDefaultPwd().booleanValue()) {
                operLog.setPassword(sysUser.getPassword());
            }
            if (Objects.equals(passwordLog.businessType().getValue(), BusinessTypeEnum.RESETPASSWORD.getValue()) && ObjectUtil.isNotNull((Object)(fullnames = (String[])map.get("fullname"))) && fullnames.length == 1 && (n2 = 0) < (n = (stringArray = fullnames).length)) {
                String fullname = stringArray[n2];
                operLog.setUserName(fullname);
                return;
            }
        } else {
            Object[] args = joinPoint.getArgs();
            if (ObjectUtil.isNotNull((Object)args)) {
                String params = this.argsArrayToString(joinPoint.getArgs());
                operLog.setOperParam(StringUtils.substring((String)params, (int)0, (int)255));
            }
        }
    }

    public PropertyPreFilters.MySimplePropertyPreFilter excludePropertyPreFilter() {
        return new PropertyPreFilters().addFilter().addExcludes(EXCLUDE_PROPERTIES);
    }

    private String argsArrayToString(Object[] paramsArray) {
        StringBuilder params = new StringBuilder();
        if (paramsArray != null && paramsArray.length > 0) {
            for (Object o : paramsArray) {
                if (!ObjectUtil.isNotNull((Object)o) || this.isFilterObject(o)) continue;
                try {
                    String jsonObj = JSONObject.toJSONString((Object)o, (SerializeFilter)this.excludePropertyPreFilter(), (SerializerFeature[])new SerializerFeature[0]);
                    params.append(jsonObj.toString()).append(" ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return params.toString().trim();
    }

    public boolean isFilterObject(Object o) {
        Map map;
        Iterator iterator;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType().isAssignableFrom(MultipartFile.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)o;
            Iterator iterator2 = collection.iterator();
            if (iterator2.hasNext()) {
                Object value = iterator2.next();
                return value instanceof MultipartFile;
            }
        } else if (Map.class.isAssignableFrom(clazz) && (iterator = (map = (Map)o).entrySet().iterator()).hasNext()) {
            Map.Entry value;
            Map.Entry entry = value = iterator.next();
            return entry.getValue() instanceof MultipartFile;
        }
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof BindingResult;
    }
}

