/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.interprecetors;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.health.service.sys.ISysLogService;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.UserUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.NoResourceFoundException;

@ControllerAdvice
public class ExceptionFilter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference
    ISysLogService sysLogService;
    @Value(value="${spring.profiles.active}")
    private String active;

    private boolean isAjaxRequest(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getHeader("isAjax")) && Objects.equals(request.getHeader("isAjax"), "true")) {
            return true;
        }
        return request.getHeader("accept").indexOf("application/json") > -1 || request.getHeader("X-Requested-With") != null && request.getHeader("X-Requested-With").indexOf("XMLHttpRequest") > -1;
    }

    private void ajaxReturn(HttpServletResponse response, ResponseData<String> data) {
        try {
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(JsonMapper.toJsonString(data));
            writer.flush();
            writer.close();
        }
        catch (IOException ioE) {
            ioE.printStackTrace();
        }
    }

    private void addLog(HttpServletRequest request, Throwable e) {
        try {
            String remoteIp;
            SysLog log = new SysLog();
            log.setTitle("\u9519\u8bef");
            log.setUsername(UserUtils.getLoginStaffName());
            log.setFullname(UserUtils.getLoginStaffName());
            log.setCid(UserUtils.getLoginStaffCompanyId());
            log.setCreateBy(UserUtils.getLoginStaffId());
            log.setUpdateBy(UserUtils.getLoginStaffId());
            log.setLogSource(Byte.valueOf((byte)1));
            log.setCompanyName(UserUtils.getCurrentCompany().getName());
            if (!StringUtils.sql_inj((String)request.getMethod()).booleanValue()) {
                log.setRequestMethod(request.getMethod());
            }
            if (!StringUtils.sql_inj((String)(remoteIp = StringUtils.getRemoteAddr((HttpServletRequest)request))).booleanValue()) {
                log.setRemoteIp(StringUtils.getRemoteAddr((HttpServletRequest)request));
            }
            if (e != null) {
                log.setType(Byte.valueOf((byte)0));
                StringBuffer errorStr = new StringBuffer();
                errorStr.append(e).append("<br/>");
                for (StackTraceElement s : e.getStackTrace()) {
                    errorStr.append(s.toString()).append("<br/>");
                }
                if (!StringUtils.sql_inj((String)errorStr.toString()).booleanValue()) {
                    log.setParams(errorStr.toString());
                }
                log.setIsValid(Boolean.valueOf(false));
            }
            if (!StringUtils.sql_inj((String)request.getRequestURI()).booleanValue()) {
                log.setRequestUri(request.getRequestURI());
            }
            log.setUserAgent(request.getHeader("user-agent"));
            log.setCreateDate(new Date());
            log.setUpdateDate(new Date());
            if (log.getIsValid() == null) {
                log.setIsValid(Global.TRUE);
            }
            ShiroPrincipal currentUser = UserUtils.getPrincipal();
            SysArea sysArea1 = currentUser.getSysArea();
            log.setSysArea(sysArea1);
            this.sysLogService.addLog(log);
        }
        catch (Exception ex) {
            this.logger.error("\u5168\u5c40\u5f02\u5e38\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25", (Throwable)ex);
        }
    }

    private ModelAndView handleException(HttpServletResponse response, HttpServletRequest request, String content, Throwable e) {
        this.addLog(request, e);
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406\uff1a\u8bf7\u6c42URI[{}], \u9519\u8bef\u7c7b\u578b[{}]", new Object[]{request.getRequestURI(), e.getClass().getSimpleName(), e});
        if (!org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.active, (CharSequence)"pro") && !org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.active, (CharSequence)"prod")) {
            content = e.getMessage();
        }
        ResponseData data = new ResponseData();
        if (this.isAjaxRequest(request)) {
            data.setState(ResponseStateEnum.fail);
            data.setContent(content);
            this.ajaxReturn(response, (ResponseData<String>)data);
            return null;
        }
        request.setAttribute("error", (Object)JsonMapper.toJsonString((Object)data));
        request.setAttribute("errorMsg", (Object)content);
        String modelView = "commons/error/default";
        if ("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01".equals(content)) {
            modelView = "commons/403";
        }
        ModelAndView modelAndView = new ModelAndView(modelView);
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            modelAndView.addObject("principal", (Object)principal);
        }
        return modelAndView;
    }

    @ExceptionHandler(value={Throwable.class})
    public ModelAndView processException(HttpServletResponse response, HttpServletRequest request, Throwable e) {
        return this.handleException(response, request, ErrorEnum.defaultError.getContent(), e);
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    public void processNoResourceFoundException(HttpServletResponse response, HttpServletRequest request, Throwable e) {
        DebugUtils.error((String)"\u8d44\u6e90\u6027\u7f3a\u5931\u5f02\u5e38\u5904\u7406\uff1a\u8bf7\u6c42URI[{}], \u9519\u8bef\u7c7b\u578b[{}]", (Object[])new Object[]{request.getRequestURI(), e.getClass().getSimpleName(), e});
    }

    @ExceptionHandler(value={UnauthorizedException.class, AuthenticationException.class, AuthorizationException.class})
    public ModelAndView processUnauthorizedException(HttpServletResponse response, HttpServletRequest request, Throwable e) {
        return this.handleException(response, request, "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", e);
    }

    @ExceptionHandler(value={HealthException.class, javax.smarthse.exception.ServiceException.class, ServiceException.class})
    public ModelAndView processHealthException(HttpServletResponse response, HttpServletRequest request, RuntimeException e) {
        return this.handleException(response, request, e.getMessage(), e);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class, JsonParseException.class, JsonMappingException.class})
    public ModelAndView processJsonParseException(HttpServletResponse response, HttpServletRequest request, Throwable e) {
        return this.handleException(response, request, "\u8bf7\u6c42\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5JSON\u683c\u5f0f", e);
    }

    @ExceptionHandler(value={DataAccessException.class})
    public ModelAndView processDatabaseTimeoutException(HttpServletResponse response, HttpServletRequest request, Throwable e) {
        return this.handleException(response, request, "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", e);
    }

    @ExceptionHandler(value={BindException.class, ConstraintViolationException.class, MethodArgumentNotValidException.class})
    public ModelAndView dealException(HttpServletResponse response, HttpServletRequest request, Exception ex) {
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.validate_fail);
        r.setContent(ResponseStateEnum.validate_fail.getName());
        if (ex instanceof ConstraintViolationException) {
            Set message = ((ConstraintViolationException)((Object)ex)).getConstraintViolations();
            map = new HashMap();
            message.forEach(msg -> {
                String path = msg.getPropertyPath().toString();
                String field = path.substring(path.indexOf(".") + 1);
                map.put(field, msg.getMessage());
            });
            r.setResult(map);
        } else if (ex instanceof MethodArgumentNotValidException) {
            allErrors = ((MethodArgumentNotValidException)ex).getBindingResult().getAllErrors();
            map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            r.setResult(map);
        } else if (ex instanceof BindException) {
            allErrors = ((BindException)ex).getBindingResult().getAllErrors();
            map = new HashMap();
            allErrors.forEach(error -> {
                FieldError fieldError = (FieldError)error;
                map.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            r.setResult(map);
        }
        if (this.isAjaxRequest(request)) {
            this.ajaxReturnV2(response, (ResponseData<Object>)r);
            return null;
        }
        request.setAttribute("error", (Object)JsonMapper.toJsonString((Object)r));
        ModelAndView modelAndView = new ModelAndView("commons/error/default");
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            modelAndView.addObject("principal", (Object)principal);
        }
        return modelAndView;
    }

    private void ajaxReturnV2(HttpServletResponse response, ResponseData<Object> data) {
        try {
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(JsonMapper.toJsonString(data));
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

