/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.interprecetors;

import cn.hutool.core.convert.Convert;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.AppConfigHolder;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.dubbo.common.extension.Activate;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.crazycake.shiro.RedisSessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer", "provider"}, order=-30000)
public class DubboRpcFilter
implements Filter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            RpcContext context = RpcContext.getContext();
            context.setAttachment("_isActualize", AppConfigHolder.getConfig("isActualize"));
            ThreadLocal thread = RedisSessionDAO.getSessionsInThread();
            if (thread != null && thread.get() != null) {
                context.setAttachment("remote_address", context.getRemoteAddressString());
                context.setAttachment("operator_id", String.valueOf(UserUtils.getLoginStaffId()));
                String username = "";
                ShiroPrincipal principal = UserUtils.getPrincipal();
                if (principal != null) {
                    username = principal.getUsername();
                }
                context.setAttachment("operator_name", username);
                HttpServletRequest request = ServletsUtil.getRequest();
                if (request != null) {
                    context.setAttachment("request_url", String.valueOf(request.getRequestURL()));
                    context.setAttachment("ip_addr", request.getRemoteAddr());
                    HttpSession session = request.getSession();
                    if (session != null) {
                        context.setAttachment("sup_id", Convert.toStr((Object)session.getAttribute("superviseLoginUserId")));
                        context.setAttachment("sup_name", Convert.toStr((Object)session.getAttribute("superviseFullName")));
                    }
                }
            }
            Result result = invoker.invoke(invocation);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            Result result = invoker.invoke(invocation);
            return result;
        }
    }
}

