/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.interprecetors;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.AppConfigHolder;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@Component
public class DefaultWebInterceptor
implements HandlerInterceptor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${devModel:false}")
    public boolean DEV_MODEL;
    @Value(value="${adminPath}")
    protected String adminPath;
    @DubboReference
    private IReformItemBasicCommandService itemBasicCommandService;
    @Value(value="${isActualize}")
    private String isActualize;
    @Value(value="${applications.url.sup}")
    private String applicationsUrlSup;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        request.getSession().setAttribute("applicationsUrlSup", (Object)this.applicationsUrlSup);
        request.getSession().setAttribute("isActualize", (Object)this.isActualize);
        request.getSession().setAttribute("actualizeCompanyName", (Object)AppConfigHolder.getConfig("actualizeCompanyName"));
        String nav = request.getServletPath();
        nav = nav.replaceAll("//", "/");
        if ("/".equals(nav)) {
            request.getRequestDispatcher(this.adminPath + "/home").forward((ServletRequest)request, (ServletResponse)response);
            return false;
        }
        Subject subject = UserUtils.getSubject();
        if (StringUtils.contains((CharSequence)nav, (CharSequence)"/login") && subject.isRemembered()) {
            request.getRequestDispatcher(this.adminPath + "/home").forward((ServletRequest)request, (ServletResponse)response);
            return false;
        }
        SysUser loginUser = UserUtils.getCurrentUser();
        if (loginUser != null) {
            UserUtils.hasBindInfo(loginUser);
            request.getSession().setAttribute("isManager", (Object)loginUser.getIsManger());
        }
        if (StringUtils.contains((CharSequence)nav, (CharSequence)"/sys/message")) {
            return true;
        }
        if (StringUtils.contains((CharSequence)nav, (CharSequence)"/base/staff/staffInfo/listData")) {
            return true;
        }
        if (StringUtils.contains((CharSequence)nav, (CharSequence)"logout") || StringUtils.contains((CharSequence)nav, (CharSequence)"/login")) {
            return true;
        }
        if (loginUser != null) {
            Long staffId = UserUtils.getLoginStaffId();
            String staffName = UserUtils.getLoginStaffName();
            if (StringUtils.isEmpty((CharSequence)staffName)) {
                staffId = null;
            }
            if (!(staffId != null || "true".equals(this.isActualize) || StringUtils.contains((CharSequence)nav, (CharSequence)"/init/linkStaff") || StringUtils.contains((CharSequence)nav, (CharSequence)"/file/") || StringUtils.contains((CharSequence)nav, (CharSequence)"/init/addOrLinkStaffInfo"))) {
                String isThirdParty = request.getParameter("isThirdParty") == null ? "false" : request.getParameter("isThirdParty");
                request.getRequestDispatcher(this.adminPath + "/init/linkStaff").forward((ServletRequest)request, (ServletResponse)response);
                return false;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (handler instanceof ResourceHttpRequestHandler) {
            return;
        }
        String nav = request.getServletPath();
        nav = nav.replaceAll("//", "/");
        if (modelAndView == null) {
            return;
        }
        if (this.DEV_MODEL) {
            request.getSession().setAttribute("javaScriptionVersion", (Object)("" + new Date().getTime()));
        } else {
            request.getSession().setAttribute("javaScriptionVersion", (Object)Constants.JAVA_SCRIPT_VERSION_VALUE);
        }
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null) {
            modelAndView.addObject("principal", (Object)principal);
            modelAndView.addObject("currentCompanyInfo", (Object)UserUtils.getCurrentCompanyFromDataCenter());
        }
        modelAndView.addObject("nav", (Object)nav);
        modelAndView.addObject("isHuadongImport", (Object)AppConfigHolder.getConfig("isHuadongImport"));
        modelAndView.addObject("loginStaffName", (Object)UserUtils.getLoginStaffName());
        modelAndView.addObject("isSharingSystem", (Object)AppConfigHolder.getConfig("isSharingSystem"));
        modelAndView.addObject("isActualize", (Object)AppConfigHolder.getConfig("isActualize"));
    }
}

