/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.interprecetors;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.UserUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import com.sx.log.util.LogUtils;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

@Component
public class BigDataLogInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BigDataLogInterceptor.class);
    @DubboReference
    private IBigDataLogProviderService bigDataLogProviderService;
    @Value(value="${appCode}")
    private String appCode;
    @Resource
    protected HttpSession session;

    public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) throws IOException {
        String actionId;
        UserRoleEnum userRole;
        Long userId;
        boolean doBigLogTwice;
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        if (!(handler instanceof HandlerMethod)) {
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        BigLog bigLog = method.getAnnotation(BigLog.class);
        if (bigLog == null) {
            return;
        }
        ActionTypeEnum actionType = bigLog.actionType();
        Object businessActionType = request.getAttribute("actionType");
        boolean doBigLog = actionType == ActionTypeEnum.LOGIN_TYPE || businessActionType == null || Objects.equals(Convert.toStr((Object)businessActionType), actionType.getValue());
        boolean bl = doBigLogTwice = actionType == ActionTypeEnum.WORK_START_TYPE && Objects.equals(Convert.toStr((Object)businessActionType), ActionTypeEnum.WORK_END_TYPE.getValue());
        if (!doBigLog && !doBigLogTwice) {
            return;
        }
        String businessId = this.resolveBusinessId(request, bigLog.businessIdParamName());
        ShiroPrincipal principal = UserUtils.getPrincipal();
        if (principal != null && Objects.equals(principal.getLoginSource(), 0)) {
            userId = Convert.toLong((Object)this.session.getAttribute("superviseLoginUserId"));
            userRole = UserRoleEnum.GOVERNMENT_STAFF_TYPE;
        } else {
            userId = UserUtils.getCurrentUserId();
            userRole = UserRoleEnum.ENTERPRISE_TYPE;
        }
        Long regionId = Optional.ofNullable(UserUtils.getPrincipal()).map(ShiroPrincipal::getSysArea).map(SysArea::getId).orElse(null);
        String regionIdStr = Convert.toStr((Object)regionId);
        String areaCode = "";
        if (CharSequenceUtil.isNotBlank((CharSequence)regionIdStr)) {
            areaCode = regionIdStr.substring(0, Math.min(regionIdStr.length(), 9));
        }
        String string = actionId = actionType == ActionTypeEnum.LOGIN_TYPE ? "" : bigLog.businessModule().getValue().concat(businessId);
        if (doBigLog) {
            this.bigDataLogProviderService.handleBigDataLog(actionType, userRole, actionId, userId, areaCode, this.appCode);
            switch (actionType) {
                case LOGIN_TYPE: {
                    LogUtils.login((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode);
                    break;
                }
                case WORK_START_TYPE: {
                    LogUtils.workStart((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode, (String)actionId);
                    break;
                }
                case WORK_END_TYPE: {
                    LogUtils.workEnd((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode, (String)actionId);
                    break;
                }
            }
        }
        if (doBigLogTwice) {
            this.bigDataLogProviderService.handleBigDataLog(ActionTypeEnum.WORK_START_TYPE, userRole, actionId, userId, areaCode, this.appCode);
            this.bigDataLogProviderService.handleBigDataLog(ActionTypeEnum.WORK_END_TYPE, userRole, actionId, userId, areaCode, this.appCode);
            LogUtils.workStart((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode, (String)actionId);
            LogUtils.workEnd((String)Convert.toStr((Object)userId), (UserRoleEnum)userRole, (String)areaCode, (String)actionId);
        }
    }

    private String resolveBusinessId(HttpServletRequest request, String paramName) throws IOException {
        JsonObject jsonObject;
        String requestBody;
        String id = request.getParameter(paramName);
        if (StringUtils.isNotBlank((String)id)) {
            return id;
        }
        Map<String, String> pathVars = this.getPathVariables(request);
        id = pathVars.get(paramName);
        if (StringUtils.isNotBlank((String)id)) {
            return id;
        }
        if (request.getContentType() != null && request.getContentType().contains("application/json") && CharSequenceUtil.isNotBlank((CharSequence)(requestBody = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding()))) && (jsonObject = JsonParser.parseString((String)requestBody).getAsJsonObject()).has(paramName)) {
            return jsonObject.get(paramName).getAsString();
        }
        Object attr = request.getAttribute(paramName);
        if (attr != null) {
            return attr.toString();
        }
        String[] uriParts = request.getRequestURI().split("/");
        return uriParts.length > 0 ? uriParts[uriParts.length - 1] : "";
    }

    private Map<String, String> getPathVariables(HttpServletRequest request) {
        return (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
    }

    @Generated
    public BigDataLogInterceptor() {
    }
}

