/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.wqyy;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.wqyy.model.param.org.WqyyOrganizationParam;
import cn.smarthse.wqyy.model.vo.org.WqyyOrganizationVo;
import cn.smarthse.wqyy.provider.company.IWqyyCompanyProviderToCompanyService;
import com.github.pagehelper.PageInfo;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wqyy/org"})
public class WqyyOrganizationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WqyyOrganizationController.class);
    @DubboReference(check=false)
    private IWqyyCompanyProviderToCompanyService companyService;

    @GetMapping(value={"/listPage"})
    public String enterpriseApplyList() {
        return "/thirdWqyy/orgList";
    }

    @GetMapping(value={"/detailPage"})
    public String orgInfoEditPage() {
        return "/thirdWqyy/orgDetail";
    }

    @Log(title="\u6761\u4ef6\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/dataList"})
    @ResponseBody
    public JqGridData<WqyyOrganizationVo> queryOrganizationData(JqGridParam param, WqyyOrganizationParam orgParam) {
        PageInfo page = this.companyService.queryOrganizationData(param, orgParam);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @Log(title="\u67e5\u770b\u673a\u6784\u8be6\u60c5")
    @GetMapping(value={"/dataDetail"})
    @ResponseBody
    public ResponseData<WqyyOrganizationVo> queryOrganizationData(Long organizationId) {
        if (organizationId == null) {
            throw new ServiceException("organizationId\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        WqyyOrganizationVo organizationVo = this.companyService.queryOrganizationDataById(organizationId);
        ResponseData data = new ResponseData();
        data.setResult((Object)organizationVo);
        return data;
    }

    @Generated
    public WqyyOrganizationController() {
    }
}

