/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.trusteeship;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfo;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfoDetail;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipOrg;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoDetailService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipManagerService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipOrgService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipServiceOrgInfoService;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoDetailQueryVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoParam;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoQueryVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/trusteeship"})
public class TrusteeshipController
extends ControllerSupport {
    @DubboReference(timeout=60000)
    private ITrusteeshipInfoService trusteeshipInfoService;
    @DubboReference(timeout=60000)
    private ITrusteeshipInfoDetailService detailService;
    @DubboReference(timeout=60000)
    private ITrusteeshipOrgService orgService;
    @DubboReference(timeout=60000)
    private ITrusteeshipServiceOrgInfoService orgInfoService;
    @DubboReference(timeout=60000)
    private ITrusteeshipManagerService trusteeshipManagerService;

    @GetMapping(value={"/checkList"})
    public String checkList(ModelMap mp) {
        Integer year = DateUtil.getYear();
        ArrayList<Integer> years = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            years.add(year - i);
        }
        mp.addAttribute("years", years);
        return "work/trusteeship/checkList";
    }

    @Log(title="\u7b2c\u4e09\u65b9\u6258\u7ba1\u6838\u67e5\u5de5\u4f5c\u5217\u8868", type=2)
    @GetMapping(value={"/checkListData"})
    @ResponseBody
    public JqGridData<TrusteeshipInfoVo> getCheckListData(JqGridParam param, TrusteeshipInfoParam trusteeshipInfoParam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        trusteeshipInfoParam.setCid(cid);
        trusteeshipInfoParam.setIsCompany(Boolean.valueOf(true));
        PageInfo list = this.trusteeshipInfoService.getTrusteeshipList(param, trusteeshipInfoParam);
        return new JqGridData(list, param);
    }

    @GetMapping(value={"/getInfo"})
    @ResponseBody
    public ResponseData<TrusteeshipInfoQueryVo> getInfo(Long id) {
        ResponseData responseData = new ResponseData();
        TrusteeshipInfoQueryVo vo = this.trusteeshipInfoService.getTrusteeshipInfoVoById(id);
        responseData.setResult((Object)vo);
        return responseData;
    }

    @GetMapping(value={"/getDetail"})
    @ResponseBody
    public ResponseData<TrusteeshipInfoDetailQueryVo> getDetail(Long id) {
        ResponseData responseData = new ResponseData();
        TrusteeshipInfoDetailQueryVo vo = this.detailService.getDetailQueryVoByInfoId(id);
        responseData.setResult((Object)vo);
        return responseData;
    }

    @GetMapping(value={"/toTrusteeshipInfo"})
    public String toTrusteeshipInfo(ModelMap m, Long id) {
        TrusteeshipInfoQueryVo vo = this.trusteeshipInfoService.getTrusteeshipInfoVoById(id);
        m.addAttribute("infoVo", (Object)vo);
        m.addAttribute("currentYear", (Object)DateUtils.getYear());
        m.addAttribute("currentQuarter", (Object)((DateUtil.getMonth() + 2) / 3));
        return "/work/trusteeship/info";
    }

    @GetMapping(value={"/toTrusteeshipDetail"})
    public String toTrusteeshipDetail(ModelMap model, Long id, String positionId) {
        TrusteeshipInfo info = this.trusteeshipInfoService.getDetailInfoById(id);
        List list = this.detailService.getDetailListByTrusteeshipId(id);
        TrusteeshipOrg trusteeshipOrg = (TrusteeshipOrg)this.orgService.getById(info.getTrusteeshipOrgId());
        ArrayList<TrusteeshipInfoDetail> unConformityList = new ArrayList<TrusteeshipInfoDetail>();
        ArrayList<TrusteeshipInfoDetail> reasonableList = new ArrayList<TrusteeshipInfoDetail>();
        ArrayList<TrusteeshipInfoDetail> unCheckList = new ArrayList<TrusteeshipInfoDetail>();
        for (TrusteeshipInfoDetail tru : list) {
            if (tru.getResult() == null) continue;
            if (tru.getResult() == 1) {
                unCheckList.add(tru);
                continue;
            }
            if (tru.getResult() == 3) {
                unConformityList.add(tru);
                continue;
            }
            if (tru.getResult() != 4) continue;
            reasonableList.add(tru);
        }
        model.addAttribute("info", (Object)info);
        model.addAttribute("detailList", (Object)list);
        model.addAttribute("unConformityList", unConformityList);
        model.addAttribute("reasonableList", reasonableList);
        model.addAttribute("unCheckList", unCheckList);
        model.addAttribute("trusteeshipOrg", (Object)trusteeshipOrg);
        model.addAttribute("currentYear", (Object)DateUtils.getYear());
        model.addAttribute("currentQuarter", (Object)((DateUtil.getMonth() + 2) / 3));
        model.addAttribute("positionId", (Object)positionId);
        return "/work/trusteeship/detail";
    }

    @GetMapping(value={"/statisticsTaskTest"})
    @ResponseBody
    public ResponseData statisticsTaskTest() {
        ResponseData response = new ResponseData();
        this.orgService.statisticsTask();
        return response;
    }

    @GetMapping(value={"/endOfQuarterlyStatisticsTaskTest"})
    @ResponseBody
    public ResponseData endOfQuarterlyStatisticsTaskTest() {
        ResponseData response = new ResponseData();
        this.orgInfoService.endOfQuarterlyStatisticsTask();
        return response;
    }

    @GetMapping(value={"/statusChangesTaskTest"})
    @ResponseBody
    public ResponseData statusChanges() {
        ResponseData response = new ResponseData();
        this.orgInfoService.statusChanges();
        return response;
    }

    @GetMapping(value={"/createYearOfTrusteeshipManager"})
    public ResponseData createYearOfTrusteeshipManager() {
        ResponseData response = new ResponseData();
        this.trusteeshipManagerService.createYearOfTrusteeshipManager();
        return response;
    }

    @GetMapping(value={"/createCurrYearOfTrusteeshipManager"})
    public ResponseData createCurrYearOfTrusteeshipManager() {
        ResponseData response = new ResponseData();
        this.trusteeshipManagerService.createCurrYearOfTrusteeshipManager();
        return response;
    }

    @GetMapping(value={"/addDetailsForInfo"})
    public ResponseData addDetailsForInfo(Long itemNo) {
        ResponseData response = new ResponseData();
        this.detailService.addDetailsForInfo(itemNo);
        return response;
    }
}

