/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.train;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.train.TrainPaperFile;
import cn.smarthse.modules.health.entity.work.train.TrainPlanSummary;
import cn.smarthse.modules.health.entity.work.train.TrainSummarize;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.modules.health.service.work.train.ITrainSummarizeService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/work/trainSummarize"})
public class TrainSummarizeController
extends ControllerSupport {
    private static final String NAV = "trainSummarize";
    @DubboReference
    private ITrainSummarizeService trainSummarizeService;
    @DubboReference
    private IBusinessNoService businessNoService;
    @DubboReference
    private ITrainPlanService trainPlanService;

    @Log(title="\u5df2\u5b8c\u6210\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u5217\u8868", type=2)
    @RequiresPermissions(value={"trainPlan.view"})
    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        Long cid = UserUtils.getLoginStaffCompanyId();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String year = sdf.format(date);
        UserUtils.startWebDataScope();
        TrainPlanSummary summ = this.trainPlanService.getTrainSumm(cid, year);
        m.put((Object)"summ", (Object)summ);
        if ("true".equals(this.isActualize)) {
            if ("true".equals(this.isChangXing)) {
                return "work/train/trainSummarize/trainSummarizeCount";
            }
            if ("true".equals(this.isHuaDong)) {
                return "work/train/trainSummarize/trainSummarizeCount2";
            }
        }
        return "work/train/trainSummarize/trainSummarizeCount";
    }

    @Log(title="\u5df2\u5b8c\u6210\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u5217\u8868", type=2)
    @RequiresPermissions(value={"trainPlan.view"})
    @RequestMapping(value={"finishedList"})
    public String finishedList() {
        this.logger.info("\u3010\u3011-\u5df2\u5b8c\u6210\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u5217\u8868");
        return "work/train/trainSummarize/finishedList";
    }

    @ResponseBody
    @RequestMapping(value={"listFinishedData"})
    public JqGridData<TrainSummarize> list(JqGridParam param, HttpSession session, ModelMap m) {
        this.logger.info("\u5df2\u5b8c\u6210\u5e74\u5ea6\u57f9\u8bad\u5e74\u603b\u7ed3\u6e05\u5355");
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo page = this.trainSummarizeService.getFinishedList(param);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @Log(title="\u8fdb\u884c\u4e2d\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u5217\u8868", type=2)
    @RequiresPermissions(value={"trainPlan.view"})
    @RequestMapping(value={"/unFinishedList"}, method={RequestMethod.GET})
    public String unFinishedList() {
        this.logger.info("\u8fdb\u884c\u4e2d\u7684\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u5de5\u4f5c");
        return "work/train/trainSummarize/unFinishedList";
    }

    @ResponseBody
    @RequestMapping(value={"listUnFinishedData"})
    public JqGridData<TrainSummarize> listUnFinishedData(JqGridParam param, HttpSession session, ModelMap m) {
        this.logger.info("\u672a\u5b8c\u6210\u5b8c\u6210\u5e74\u5ea6\u57f9\u8bad\u5e74\u603b\u7ed3\u6e05\u5355");
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo page = this.trainSummarizeService.getUnFinishedList(param);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @RequiresPermissions(value={"trainPlan.edit"})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String page_add(HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u65b0\u589e\u9875");
        Long cid = UserUtils.getLoginStaffCompanyId();
        TrainSummarize data = new TrainSummarize();
        String no = this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.TRAINSUMMARIZE.getCode());
        data.setNo(no);
        m.put((Object)"data", (Object)data);
        m.put((Object)"nav_short", (Object)NAV);
        return "work/train/trainSummarize/addTrainSummarize";
    }

    @RequiresPermissions(value={"trainPlan.edit"})
    @Log(title="\u65b0\u589e/\u7f16\u8f91\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u4fe1\u606f", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseData<TrainSummarize> ajax_add(HttpServletRequest request, TrainSummarize info, Boolean finish) {
        this.logger.info("ajax-\u3010\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u3011-\u65b0\u589e");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        String[] fileids = request.getParameterValues("trainFiles");
        List<TrainPaperFile> fileList = this.getFiles(fileids);
        if (info.getId() != null && StringUtils.isEmpty((CharSequence)info.getOrgId())) {
            info.setOrgId("" + orgId);
        }
        if (finish != null) {
            info.setIsFinish(finish);
        }
        info.setFileList(fileList);
        ValidateUtil.valid((Object)info, null);
        if (info.getOutlay() == null) {
            info.setOutlay(new BigDecimal(Constants.EMPTY_NUMBER.byteValue()));
        }
        TrainSummarize result = new TrainSummarize();
        result = info.getId() != null ? this.trainSummarizeService.updateAndFile(info, staffid) : this.trainSummarizeService.addAndFile(info, staffid, cid);
        data.setResult((Object)result);
        data.setContent("\u7f16\u8f91\u6210\u529f\uff01");
        return data;
    }

    private List<TrainPaperFile> getFiles(String[] fileids) {
        if (fileids == null || fileids.length == 0) {
            return null;
        }
        ArrayList<TrainPaperFile> files = new ArrayList<TrainPaperFile>();
        for (int a = 0; a < fileids.length; ++a) {
            TrainPaperFile tfile = new TrainPaperFile();
            if (fileids[a] == null || fileids[a] == "") continue;
            long id = Long.parseLong(fileids[a]);
            SysFileModel file = SysFileUtil.getFileById(id);
            tfile.setFileId(Long.valueOf(id));
            tfile.setFileName(file.getFileName());
            tfile.setFileUrl(file.getOssUrl());
            files.add(tfile);
        }
        if (files.size() == 0) {
            return null;
        }
        return files;
    }

    @Log(title="\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u67e5\u770b", type=2)
    @RequiresPermissions(value={"trainPlan.view"})
    @RequestMapping(value={"view"}, method={RequestMethod.GET})
    public String view(Long id, HttpSession session, ModelMap m) {
        this.logger.info("\u5e74\u5ea6\u57f9\u8bad\u5e74\u603b\u7ed3 \u67e5\u770b");
        TrainSummarize data = new TrainSummarize();
        if (id != null && (data = this.trainSummarizeService.getByIdWithFile(id)).getOutlay() != null && data.getOutlay().compareTo(BigDecimal.ZERO) == -1) {
            data.setOutlay(null);
        }
        m.put((Object)"data", (Object)data);
        return "work/train/trainSummarize/viewTrainSummarize";
    }

    @RequiresPermissions(value={"trainPlan.edit"})
    @RequestMapping(value={"edit"}, method={RequestMethod.GET})
    public String page_edit(Long id, HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u4fee\u6539\u9875");
        TrainSummarize data = new TrainSummarize();
        if (id != null && (data = this.trainSummarizeService.getByIdWithFile(id)).getOutlay() != null && data.getOutlay().compareTo(BigDecimal.ZERO) == -1) {
            data.setOutlay(null);
        }
        m.put((Object)"data", (Object)data);
        return "work/train/trainSummarize/addTrainSummarize";
    }

    @RequiresPermissions(value={"trainPlan.edit"})
    @Log(title="\u5220\u9664\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u8bb0\u5f55", type=22)
    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> ajax_delete(Long id, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + id);
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData data = new ResponseData();
        TrainSummarize info = (TrainSummarize)this.trainSummarizeService.getById(id);
        info.setIsValid(Boolean.valueOf(false));
        this.trainSummarizeService.update((Object)info, staffid);
        data.setContent("\u5220\u9664\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"trainPlan.view"})
    @Log(title="\u5bfc\u51fa\u5df2\u5b8c\u6210\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3", type=24)
    @RequestMapping(value={"export"})
    public void exportManagerCert(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u5df2\u5b8c\u6210\u5e74\u5ea6\u57f9\u8bad\u5e74\u603b\u7ed3\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5df2\u5b8c\u6210\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u6c47\u603b" + dateFormat.format(new Date()) + ".xls";
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u5e74\u5ea6|year", "\u603b\u7ed3\u540d\u79f0|name", "\u7f16\u5199\u4eba|createName", "\u5f52\u6863\u65f6\u95f4|updateDate"};
        UserUtils.startWebDataScope();
        List list = this.trainSummarizeService.getFinishedByCid(cid);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport3("\u5df2\u5b8c\u6210\u5e74\u5ea6\u57f9\u8bad\u603b\u7ed3\u6c47\u603b", colums, list, (OutputStream)response.getOutputStream());
    }
}

