/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.train;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.work.train.QueryTrainParam;
import cn.smarthse.modules.health.entity.work.train.StaffTrainInfo;
import cn.smarthse.modules.health.entity.work.train.TrainPlanImportVo;
import cn.smarthse.modules.health.entity.work.train.Year;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.service.work.train.ITrainAttendService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanImportService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/work/trainCount"})
public class TrainPlanCountController
extends ControllerSupport {
    @DubboReference
    ITrainPlanImportService trainPlanImportService;
    @DubboReference
    ITrainAttendService trainAttendService;
    @DubboReference
    ITrainPlanService trainPlanService;

    @RequestMapping(value={"getTrainStaffCountPage"})
    public String getTrainStaffCountPage(ModelMap m) {
        Integer year = DateUtil.getYear();
        ArrayList<Integer> years = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            years.add(year - i);
        }
        m.put((Object)"year", (Object)year);
        m.put((Object)"years", years);
        return "work/train/trainPlan/staffCountByTimeListPage";
    }

    @RequestMapping(value={"getTrainStaffCountByMonthPage"})
    public String getTrainStaffCountByMonthPage(ModelMap m, Integer year, Integer month) {
        QueryTrainParam queryTrainParam = new QueryTrainParam();
        UserUtils.startWebDataScope();
        Date beginTime = DateUtil.getMinDateByMonth((Integer)year, (Integer)month);
        Date endTime = DateUtil.getMaxDateByMonth((Integer)year, (Integer)month);
        Long cid = UserUtils.getLoginStaffCompanyId();
        queryTrainParam.setCid(cid);
        queryTrainParam.setBeginTime(beginTime);
        queryTrainParam.setEndTime(endTime);
        Integer staffNum = this.trainAttendService.getTrainStaffNum(queryTrainParam);
        m.put((Object)"staffNum", (Object)staffNum);
        m.put((Object)"year", (Object)year);
        m.put((Object)"month", (Object)month);
        return "work/train/trainPlan/staffTrainCountByMonthList";
    }

    @ResponseBody
    @PostMapping(value={"staffListData"})
    @Log(title="\u4eba\u5458\u57f9\u8bad\u8bb0\u5f55\u5217\u8868", type=2)
    public JqGridData<StaffTrainInfo> staffListData(JqGridParam param, Integer year, Integer month, String staffName) {
        QueryTrainParam queryTrainParam = new QueryTrainParam();
        UserUtils.startWebDataScope();
        Date beginTime = DateUtil.getMinDateByMonth((Integer)year, (Integer)month);
        Date endTime = DateUtil.getMaxDateByMonth((Integer)year, (Integer)month);
        Long cid = UserUtils.getLoginStaffCompanyId();
        queryTrainParam.setCid(cid);
        queryTrainParam.setStaffName(staffName);
        queryTrainParam.setBeginTime(beginTime);
        queryTrainParam.setEndTime(endTime);
        PageInfo listData = this.trainAttendService.getTrainRecordListDataGroupByStaffId(param, queryTrainParam);
        return new JqGridData(listData, param);
    }

    @RequestMapping(value={"getImportTrainInfoPage"})
    public String getImportStaffPage(ModelMap m) {
        return "work/train/trainPlan/import";
    }

    @RequestMapping(value={"/importTrainInfo"})
    public String importWorkInfo(Long fileId, HttpServletRequest request, ModelMap m) {
        String importResult;
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        Boolean haveError = false;
        Boolean isImport = false;
        List list = this.trainPlanImportService.getTrainInfoFromExcel(ossfile, loginStaffId, cid);
        if (list == null || list.size() < 1) {
            m.put((Object)"noData", (Object)true);
            return "work/train/trainPlan/importTrainInfo";
        }
        ArrayList<TrainPlanImportVo> errorList = new ArrayList<TrainPlanImportVo>();
        for (TrainPlanImportVo vo : list) {
            if (vo.getDataState().byteValue() != StaffInfoImportStateEnum.error.getValue()) continue;
            errorList.add(vo);
        }
        if (errorList != null && errorList.size() > 0) {
            haveError = true;
            m.put((Object)"errorList", errorList);
            m.put((Object)"haveError", (Object)haveError);
            return "work/train/trainPlan/importTrainInfo";
        }
        try {
            int importNum = this.trainPlanImportService.importTrainInfo(list, cid, loginStaffId);
            isImport = true;
            importResult = "\u5bfc\u5165\u6210\u529f\uff01\u5bfc\u5165\u57f9\u8bad\u6570\u636e" + importNum + "\u6761\u3002";
            m.put((Object)"importResult", (Object)importResult);
        }
        catch (Exception e) {
            isImport = true;
            importResult = "\u5bfc\u5165\u5931\u8d25" + String.valueOf(e);
            m.put((Object)"importResult", (Object)importResult);
        }
        m.put((Object)"isImport", (Object)isImport);
        return "work/train/trainPlan/importTrainInfo";
    }

    @RequestMapping(value={"getTrainingNumberByTime"}, method={RequestMethod.GET})
    public String getTrainingNumberByTime(ModelMap m, Integer year) {
        ArrayList<Year> yearList = new ArrayList<Year>();
        if (year == null || year == 1) {
            year = DateUtil.getYear();
            yearList.add(this.getYearData(year));
            yearList.add(this.getYearData(year - 1));
            yearList.add(this.getYearData(year - 2));
        } else {
            yearList.add(this.getYearData(year));
        }
        m.put((Object)"yearList", yearList);
        return "work/train/trainPlan/staffCountByTimeListData";
    }

    private Year getYearData(Integer year) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Year y = new Year();
        List Mlist = this.trainPlanService.getTrainNumByTime(year, cid);
        Integer total = this.trainPlanService.getTrainStaffNumByYear(year, cid);
        y.setYearTrainingNum(total.intValue());
        y.setYear(year.intValue());
        y.setMonthItemList(Mlist);
        return y;
    }
}

