/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.train;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.train.TrainFile;
import cn.smarthse.modules.health.entity.work.train.TrainFileType;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.work.train.ITrainFileService;
import cn.smarthse.modules.health.service.work.train.ITrainFileTypeService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/work/trainFile"})
public class TrainFileController
extends ControllerSupport {
    private static final String NAV = "trainFile";
    @DubboReference
    private ITrainFileService trainFileService;
    @DubboReference
    private ITrainFileTypeService trainFileTypeService;
    @DubboReference
    private IBusinessNoService businessNoService;

    @Log(title="\u57f9\u8bad\u76f8\u5173\u8d44\u6599\u5217\u8868", type=2)
    @RequiresPermissions(value={"trainPlan.view"})
    @RequestMapping
    public String index(TrainFile info, HttpSession session, ModelMap m) {
        this.logger.info("\u57f9\u8bad\u76f8\u5173\u8d44\u6599\u5217\u8868");
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setCid(cid);
        if (info == null || info.getType() == null) {
            info.setType(Byte.valueOf((byte)1));
        }
        return "work/train/trainFile/" + this.getJspName(info.getType()) + "List";
    }

    private String getJspName(byte type) {
        String jspName = "book";
        if (type == 2) {
            jspName = "exam";
        }
        if (type == 3) {
            jspName = "material";
        }
        return jspName;
    }

    @ResponseBody
    @RequestMapping(value={"listData"}, method={RequestMethod.GET})
    public JqGridData<TrainFile> getTrainFileList(JqGridParam param, byte type, String name, String ids) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        TrainFile info = new TrainFile();
        info.setCid(cid);
        info.setType(Byte.valueOf(type));
        info.setName(name);
        info.setNotInIds(ids);
        PageInfo trainFilePage = this.trainFileService.getTrainFileList(info, param);
        JqGridData data = new JqGridData(trainFilePage, param);
        return data;
    }

    @Log(title="\u7f16\u8f91\u57f9\u8bad\u76f8\u5173\u8d44\u6599", type=21)
    @RequiresPermissions(value={"trainPlan.edit"})
    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String info(TrainFile info, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List fileIds = new ArrayList();
        if (info != null && info.getId() != null) {
            TrainFileType type;
            if ((info = (TrainFile)this.trainFileService.getById(info.getId())).getFileType() != null && (type = (TrainFileType)this.trainFileTypeService.getById(info.getFileType())) != null) {
                info.setTypeName(type.getName());
            }
            fileIds = StringUtils.parseToLongList((String)info.getFileId(), (String)",");
        } else {
            info.setNo(this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.TRAINSUMMARIZE.getCode()));
        }
        m.put((Object)"nav", (Object)NAV);
        m.put((Object)"data", (Object)info);
        m.put((Object)"fileIds", fileIds);
        return "work//train/trainFile/fileInfo";
    }

    @Log(title="\u67e5\u770b\u57f9\u8bad\u76f8\u5173\u8d44\u6599", type=2)
    @RequiresPermissions(value={"trainPlan.view"})
    @RequestMapping(value={"/viewinfo"}, method={RequestMethod.GET})
    public String viewinfo(TrainFile info, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List fileIds = new ArrayList();
        if (info != null && info.getId() != null) {
            TrainFileType type;
            if ((info = (TrainFile)this.trainFileService.getById(info.getId())).getFileType() != null && (type = (TrainFileType)this.trainFileTypeService.getById(info.getFileType())) != null) {
                info.setTypeName(type.getName());
            }
            fileIds = StringUtils.parseToLongList((String)info.getFileId(), (String)",");
        } else {
            info.setNo(this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.TRAINSUMMARIZE.getCode()));
        }
        m.put((Object)"nav", (Object)NAV);
        m.put((Object)"data", (Object)info);
        m.put((Object)"fileIds", fileIds);
        return "work/train/trainFile/fileView";
    }

    @RequiresPermissions(value={"trainPlan.edit"})
    @Log(title="\u65b0\u589e\u57f9\u8bad\u76f8\u5173\u8d44\u6599", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addFile"}, method={RequestMethod.POST})
    public ResponseData<TrainFile> addFile(HttpServletRequest request, TrainFile info, ModelMap m) {
        this.logger.info("\u3010\u57f9\u8bad\u76f8\u5173\u8d44\u6599\u3011- \u65b0\u589e/\u4fee\u6539");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        String[] fileids = request.getParameterValues("trainFiles");
        Object ids = new String();
        if (fileids != null && fileids.length != 0) {
            for (String fileid : fileids) {
                ids = fileid + "," + (String)ids;
            }
            info.setFileId((String)ids);
        } else {
            info.setFileId(",");
        }
        if (info != null && info.getId() != null) {
            this.trainFileService.updateWithHistory(info, staffid, cid);
        } else {
            info = this.trainFileService.addWithHistory(info, staffid, cid);
        }
        data.setResult((Object)info);
        data.setContent("\u64cd\u4f5c\u6210\u529f\uff01");
        return data;
    }

    @RequiresPermissions(value={"trainPlan.edit"})
    @Log(title="\u5220\u9664\u57f9\u8bad\u76f8\u5173\u8d44\u6599", type=22)
    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public ResponseData<Integer> delete(String ids, ModelMap m) {
        this.logger.info("\u3010\u57f9\u8bad\u76f8\u5173\u8d44\u6599\u3011- \u5220\u9664");
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (StringUtils.isNotEmpty((String)ids)) {
            List idList = StringUtils.parseToLongList((String)ids, (String)",");
            for (Long id : idList) {
                TrainFile file = (TrainFile)this.trainFileService.getById(id);
                file.setIsValid(Boolean.valueOf(false));
                this.trainFileService.delWithHis(file, staffid, cid);
            }
        }
        data.setContent("\u5220\u9664\u6210\u529f\uff01");
        return data;
    }

    @RequiresPermissions(value={"trainPlan.edit"})
    @Log(title="\u65b0\u589e/\u7f16\u8f91\u57f9\u8bad\u76f8\u5173\u8d44\u6599\u7c7b\u578b", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addType"}, method={RequestMethod.POST})
    public ResponseData<Integer> addType(TrainFileType info, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData data = new ResponseData();
        if (info != null && info.getId() != null) {
            this.trainFileTypeService.updateWithHistory(info, staffid);
        } else {
            this.trainFileTypeService.addWithHistory(info, staffid, cid);
        }
        data.setContent("\u64cd\u4f5c\u6210\u529f\uff01");
        return data;
    }

    @RequiresPermissions(value={"trainPlan.edit"})
    @Log(title="\u5220\u9664\u57f9\u8bad\u76f8\u5173\u8d44\u6599\u7c7b\u578b", type=22)
    @ResponseBody
    @RequestMapping(value={"/delType"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> deleteType(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        TrainFileType type = new TrainFileType();
        type.setId(id);
        try {
            type.setIsValid(Boolean.valueOf(false));
            this.trainFileTypeService.deleteWithHis(type, staffid, cid);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }

    @RequiresPermissions(value={"trainPlan.view"})
    @RequestMapping(value={"/typeSet"}, method={RequestMethod.GET})
    public String typeSet(TrainFileType type, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        type.setCid(cid);
        m.put((Object)"query", (Object)type);
        return "work/train/trainFile/typeSet";
    }

    @ResponseBody
    @RequestMapping(value={"listType"}, method={RequestMethod.GET})
    public JqGridData<TrainFileType> getTypeByType(JqGridParam param, TrainFileType type) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        type.setCid(cid);
        PageInfo trainTypePage = this.trainFileTypeService.getTrainFileList(type, param);
        JqGridData data = new JqGridData(trainTypePage, param);
        return data;
    }

    @RequestMapping(value={"/getType"}, method={RequestMethod.GET})
    public String typeinfo(TrainFileType info, HttpSession session, ModelMap m) {
        if (info != null && info.getId() != null) {
            info = (TrainFileType)this.trainFileTypeService.getById(info.getId());
        }
        m.put((Object)"nav", (Object)NAV);
        m.put((Object)"data", (Object)info);
        return "work/train/trainFile/typeInfo";
    }

    @RequestMapping(value={"info/types"}, method={RequestMethod.GET})
    public String infoTypes(HttpSession session, ModelMap m, String type) {
        m.put((Object)"type", (Object)type);
        return "work/train/trainFile/trainFileType";
    }

    @RequestMapping(value={"getSelectTypeList"}, method={RequestMethod.GET})
    public String getSelectTypeList(HttpSession session, ModelMap m, TrainFileType type) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        type.setCid(cid);
        List types = this.trainFileTypeService.listByType(type);
        m.put((Object)"query", (Object)type);
        m.put((Object)"list", (Object)types);
        return "work/train/trainFile/trainFileTypeList";
    }

    @ResponseBody
    @RequestMapping(value={"getTypeList"}, method={RequestMethod.GET})
    public JqGridData<TrainFileType> getTypeList(JqGridParam param, byte type) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo trainFilePage = this.trainFileTypeService.getTypePage(cid, type, param);
        JqGridData data = new JqGridData(trainFilePage, param);
        return data;
    }
}

