/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.train;

import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.services.wanda.api.entity.WandaTrainData;
import cn.smarthse.services.wanda.api.service.IWandaTrainDataService;
import cn.smarthse.web.util.UserUtils;
import java.io.Serializable;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"work/train/data"})
public class TrainDataController {
    @DubboReference(timeout=60000)
    IWandaTrainDataService wandaTrainDataService;

    @GetMapping(value={"/index"})
    public String index() {
        return "/work/train/trainData/index";
    }

    @GetMapping(value={"/listData"})
    @ResponseBody
    public LayUiResponseResult<WandaTrainData> listData(SearchParam param) {
        param.setUnifiedSocialCc(Objects.requireNonNull(UserUtils.getCurrentCompany()).getUnifiedSocialCc());
        return this.wandaTrainDataService.listPage(param);
    }

    @GetMapping(value={"/detail"})
    public String detail(Long id, Model model) {
        WandaTrainData data = (WandaTrainData)this.wandaTrainDataService.getById((Serializable)id);
        model.addAttribute("data", (Object)data);
        return "/work/train/trainData/detail";
    }

    @GetMapping(value={"/sync2Company"})
    @ResponseBody
    public String sync2Company(String staffComCode) {
        this.wandaTrainDataService.mitigatingRisks(staffComCode);
        return "success";
    }
}

