/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.train;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.train.QueryTrainParam;
import cn.smarthse.modules.health.entity.work.train.StaffTrainInfo;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.service.work.train.ITrainAttendService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/personnelTrainingRecord"})
public class PersonnelTrainingRecordController
extends ControllerSupport {
    @DubboReference
    private ITrainPlanService trainPlanService;
    @DubboReference
    private ITrainAttendService trainAttendService;
    @Value(value="${isHuadong}")
    private String isHuadong;

    @RequiresPermissions(value={"trainPlan.view"})
    @RequestMapping
    @Log(title="\u4eba\u5458\u57f9\u8bad\u8bb0\u5f55\u9875\u9762", type=28)
    public String index() {
        return "work/train/trainPlan/personnelTrainingRecordList";
    }

    @GetMapping(value={"/toPersonnelTrainingListPage"})
    @Log(title="\u4eba\u5458\u57f9\u8bad\u8bb0\u5f55\u9875\u9762(\u534e\u4e1c\u533b\u836f\u5916\u90e8\u8bbf\u95ee\u94fe\u63a5)", type=28)
    public String toPersonnelTrainingListPage() {
        if (!"true".equalsIgnoreCase(this.isHuadong)) {
            return "redirect:/login";
        }
        return "work/train/trainPlan/personnelTrainingRecordListOut";
    }

    @ResponseBody
    @PostMapping(value={"trainRecordListDataOut"})
    @Log(title="\u4eba\u5458\u57f9\u8bad\u8bb0\u5f55\u5217\u8868(\u534e\u4e1c\u533b\u836f\u5916\u90e8\u8bbf\u95ee\u94fe\u63a5)", type=2)
    public JqGridData<StaffTrainInfo> trainRecordListDataOut(JqGridParam param, QueryTrainParam queryTrainParam) {
        PageInfo listData = this.trainAttendService.getTrainRecordListDataGroupByStaffId(param, queryTrainParam);
        return new JqGridData(listData, param);
    }

    @ResponseBody
    @PostMapping(value={"trainRecordListData"})
    @Log(title="\u4eba\u5458\u57f9\u8bad\u8bb0\u5f55\u5217\u8868", type=2)
    public JqGridData<StaffTrainInfo> trainRecordListData(JqGridParam param, QueryTrainParam queryTrainParam) {
        UserUtils.startWebDataScope();
        Long cid = UserUtils.getLoginStaffCompanyId();
        queryTrainParam.setCid(cid);
        PageInfo listData = this.trainAttendService.getTrainRecordListDataGroupByStaffId(param, queryTrainParam);
        return new JqGridData(listData, param);
    }

    @RequiresPermissions(value={"trainPlan.view"})
    @RequestMapping(value={"export"})
    @Log(title="\u5bfc\u51fa\u4eba\u5458\u57f9\u8bad\u8bb0\u5f55\u5217\u8868", type=24)
    public void exportManagerCert(HttpServletResponse response, QueryTrainParam queryTrainParam) throws Exception {
        this.logger.info("\u3010\u6559\u80b2\u57f9\u8bad\u2014\u2014\u2014\u2014\u4eba\u5458\u57f9\u8bad\u8bb0\u5f55\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u4eba\u5458\u57f9\u8bad\u8bb0\u5f55\u5217\u8868" + dateFormat.format(new Date()) + ".xls";
        Long cid = UserUtils.getLoginStaffCompanyId();
        queryTrainParam.setCid(cid);
        ArrayList list = this.trainAttendService.getTrainRecordListData(queryTrainParam);
        List staffIdss = queryTrainParam.getStaffIdss();
        if (!CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty((Collection)staffIdss)) {
            ArrayList tempList = new ArrayList();
            list.forEach(vo -> {
                if (staffIdss.contains(vo.getStaffId())) {
                    tempList.add(vo);
                }
            });
            list = tempList;
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listExcel = new ExportExcel();
        listExcel.simpleExport3("\u4eba\u5458\u57f9\u8bad\u8bb0\u5f55\u5217\u8868", queryTrainParam.getColums(), list, (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @GetMapping(value={"trainAttendsListData"})
    @Log(title="\u67e5\u770b\u4e2a\u4eba\u57f9\u8bad\u4fe1\u606f", type=28)
    public JqGridData<TrainAttend> trainAttendsListData(JqGridParam param, Long trainId) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo page = this.trainPlanService.trainAttendsData(param, trainId);
        return new JqGridData(page, param);
    }
}

