/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.train;

import cn.smarthse.common.util.AesUtil;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.web.controller.CacheControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/enterpriseOnlineTrain"})
public class OlineTrainController
extends CacheControllerSupport {
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @Value(value="${health_online_training_url}")
    protected String onlineTrainUrl;
    @Value(value="${health_online_training_redirect_url}")
    protected String onlineTrainRedirectUrl;
    @Value(value="${health_online_training_aes_key}")
    protected String AES_KEY;

    @GetMapping(value={"/toThird"})
    @RequiresPermissions(value={"managerTrain"})
    public String toOnlineTrain(@RequestParam(value="redirectUrl", required=false) String redirectUrl, @RequestParam(value="loginUserType", defaultValue="0") Integer loginUserType) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (Objects.isNull(company)) {
            throw new HealthException("\u627e\u4e0d\u5230\u8be5\u4f01\u4e1a\u76f8\u5173\u4fe1\u606f");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("time", (Object)System.currentTimeMillis());
        jsonObject.put("redirectUrl", (Object)(StringUtils.hasLength((String)redirectUrl) ? redirectUrl : this.onlineTrainRedirectUrl));
        jsonObject.put("username", (Object)UserUtils.getCurrentUser().getUsername());
        jsonObject.put("token", (Object)UserUtils.getLoginStaffCompanyId());
        jsonObject.put("name", (Object)company.getName());
        jsonObject.put("creditCode", (Object)company.getUnifiedSocialCc());
        jsonObject.put("areaId", (Object)company.getAreaDetailId());
        jsonObject.put("contactTel", (Object)UserUtils.getCurrentUser().getMobile());
        jsonObject.put("belongType", (Object)(company.getBelongType() == null ? 0 : company.getBelongType()));
        Long industryCategory = company.getIndustryCategory();
        if (Objects.isNull(industryCategory)) {
            throw new HealthException("\u60a8\u597d\uff0c\u8bf7\u5148\u81f3\u3010\u57fa\u7840\u4fe1\u606f\u7ba1\u7406\u3011\u4e2d\u5b8c\u5584\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f");
        }
        IndustryModel industry = this.industryProvideService.getIndustryById(industryCategory);
        jsonObject.put("industryCode", (Object)(Objects.nonNull(industry) ? industry.getCode() : null));
        jsonObject.put("isTest", (Object)(company.getIsTest() == null ? Boolean.FALSE : company.getIsTest()));
        jsonObject.put("businessState", (Object)company.getBusinessState());
        jsonObject.put("superviseIsHide", (Object)(company.getSuperviseIsHide().equals(Boolean.FALSE) ? 0 : 1));
        String sign = AesUtil.encrypt((String)jsonObject.toString(), (String)this.AES_KEY);
        return "redirect:" + this.onlineTrainUrl + "?sign=" + sign + "&type=2&loginUserType=" + loginUserType;
    }
}

