/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.thirdtime.v3221;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleRemarkEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStateEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideProgressService;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.param.threeTime.EditParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.web.controller.base.BaseController;
import cn.smarthse.web.util.UserUtils;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"work/threeTime"})
public class ThreeTimeController {
    @Autowired
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    ITsProjectSimpleService tsProjectSimpleService;
    @DubboReference(timeout=600000, check=false)
    IKeyFactoryService keyFactoryService;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileProvideService;
    @DubboReference(timeout=600000, check=false)
    IKeyFactoryApprovalHistoryService keyFactoryApprovalHistoryService;
    @DubboReference
    IReformItemBasicService reformItemBasicService;
    @DubboReference(check=false)
    private INewCompanyGuideProgressService newCompanyGuideProgressService;
    @Autowired
    private BaseController baseController;
    private static final List<String> backReasonList = Arrays.asList("\u8fdb\u884c\u4e2d\u7684\u4e09\u540c\u65f6\u9879\u76ee\u5c06\u4e8e2024\u5e743\u67081\u65e5\u91cd\u65b0\u8bc6\u522b\u5e76\u63a8\u9001\u98ce\u9669\u3002", "\u8fdb\u884c\u4e2d\u7684\u4e09\u540c\u65f6\u9879\u76ee\u5c06\u4e8e2025\u5e743\u67081\u65e5\u91cd\u65b0\u8bc6\u522b\u5e76\u63a8\u9001\u98ce\u9669\u3002");
    @Resource
    HttpSession session;

    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"thirdtime"})
    public String index(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int closeNum = this.tsProjectSimpleService.countClosedNum(cid);
        model.addAttribute("closeNum", (Object)closeNum);
        return "/work/threeTime/index";
    }

    @GetMapping(value={"/test"})
    @ResponseBody
    public String test() {
        this.tsProjectSimpleService.changeLastYearINGProjectStatus(UserUtils.getLoginStaffCompanyId());
        return "success";
    }

    @GetMapping(value={"/info"})
    @ResponseBody
    public ResponseData<TsProjectSimple> info(Long id) {
        TsProjectSimple tsProjectSimple = null;
        if (id != null) {
            tsProjectSimple = this.tsProjectSimpleService.getDetailById(id);
        }
        if (Objects.isNull(tsProjectSimple)) {
            tsProjectSimple = new TsProjectSimple();
        }
        return ResponseData.success((Object)tsProjectSimple);
    }

    @GetMapping(value={"/syncData"})
    @ResponseBody
    public String syncData() {
        this.tsProjectSimpleService.syncData(UserUtils.getLoginStaffCompanyId());
        return "suceess";
    }

    @GetMapping(value={"/listData"})
    @ResponseBody
    public LayUiResponseResult<TsProjectSimple> listData(SearchParam param) {
        this.setSearchParam(param);
        LayUiResponseResult tsProjectSimpleLayUiResponseResult = this.tsProjectSimpleService.pageList(param);
        return tsProjectSimpleLayUiResponseResult;
    }

    @PostMapping(value={"/del"})
    @ResponseBody
    @RequiresPermissions(value={"thirdtime.edit"})
    public ResponseData del(Long id) {
        ResponseData data = new ResponseData();
        TsProjectSimple dbData = (TsProjectSimple)this.tsProjectSimpleService.getById(id);
        if (dbData == null) {
            data.setContent("id\u4e0d\u5b58\u5728");
            data.setState(ResponseStateEnum.fail);
        }
        try {
            this.tsProjectSimpleService.delTsProject(dbData, UserUtils.getLoginStaffId());
            data.setContent("\u5220\u9664\u6210\u529f");
            data.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25");
            data.setState(ResponseStateEnum.fail);
        }
        return data;
    }

    @GetMapping(value={"/detail"})
    public String detail(Long id, Model model) {
        CompanySuperviseModel company;
        Date storageDate;
        Long cid = UserUtils.getLoginStaffCompanyId();
        List companyList = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByCid((List)CollUtil.toList((Object[])new Long[]{cid}));
        if (CollUtil.isNotEmpty((Collection)companyList) && (storageDate = (company = (CompanySuperviseModel)companyList.get(0)).getGradeCreateDate()) != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            model.addAttribute("storageDate", (Object)sdf.format(storageDate));
        }
        TsProjectSimple tsProjectSimple = new TsProjectSimple();
        if (Objects.nonNull(id)) {
            tsProjectSimple = this.tsProjectSimpleService.getDetailById(id);
            if (TsProjectSimpleStatusEnum.AUDIT.getCode().equals(tsProjectSimple.getStatus())) {
                return "redirect:/work/threeTime/view?id=" + id;
            }
        }
        model.addAttribute("data", (Object)tsProjectSimple);
        model.addAttribute("isSysBack", (Object)backReasonList.contains(tsProjectSimple.getRemark()));
        model.addAttribute("isEdit", (Object)true);
        model.addAttribute("isNew", (Object)Objects.isNull(id));
        return "/work/threeTime/detail";
    }

    @GetMapping(value={"/view"})
    public String view(Long id, Model model) {
        TsProjectSimple tsProjectSimple = this.tsProjectSimpleService.getDetailById(id);
        model.addAttribute("data", (Object)tsProjectSimple);
        model.addAttribute("isSysBack", (Object)backReasonList.contains(tsProjectSimple.getRemark()));
        model.addAttribute("isEdit", (Object)false);
        model.addAttribute("isNew", (Object)false);
        return "/work/threeTime/detail";
    }

    @GetMapping(value={"/evidenceInfo"})
    @ResponseBody
    public LayUiResponseResult evidenceInfo(Long tsId) {
        TsProjectSimple tsProjectSimple = (TsProjectSimple)this.tsProjectSimpleService.getById(tsId);
        List fileModelList = this.sysFileProvideService.getListByIds(tsProjectSimple.getEvidence());
        if (CollectionUtils.isEmpty((Collection)fileModelList)) {
            return LayUiResponseResult.success(Collections.emptyList());
        }
        return LayUiResponseResult.success((Object)fileModelList);
    }

    @PostMapping(value={"/saveInfo"})
    @ResponseBody
    @RequiresPermissions(value={"thirdtime.edit"})
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.WORK_START_TYPE, businessModule=BigLogBusinessModuleEnum.module2, businessIdParamName="keyFactoryId")
    public ResponseData saveInfo(@RequestBody EditParam param, HttpServletRequest request) {
        ActionTypeEnum actionType;
        ResponseData data = new ResponseData();
        try {
            if (param.getMissingItem() == null) {
                this.verify(param);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            data.setContent(e.getMessage());
            data.setState(ResponseStateEnum.fail);
            request.setAttribute("actionType", (Object)ActionTypeEnum.BIZ_LOG_TYPE.getValue());
            return data;
        }
        param.setCurrentCompany(UserUtils.getCurrentCompany());
        param.setStaffInfo(UserUtils.getLoginStaff());
        TsProjectSimple tsProjectSimple = new TsProjectSimple();
        BeanUtils.copyProperties((Object)param, (Object)tsProjectSimple);
        if (param.getEditType() == 1) {
            if (param.getStatus() == null || param.getStatus() != null && TsProjectSimpleStatusEnum.DRAFT.getCode().equals(param.getStatus())) {
                tsProjectSimple.setStatus(TsProjectSimpleStatusEnum.DRAFT.getCode());
            }
            actionType = ActionTypeEnum.BIZ_LOG_TYPE;
        } else if (param.getIsComplete().booleanValue()) {
            tsProjectSimple.setStatus(TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode());
            tsProjectSimple.setIsFinish(Boolean.valueOf(true));
            actionType = ActionTypeEnum.WORK_END_TYPE;
        } else {
            tsProjectSimple.setStatus(TsProjectSimpleStatusEnum.AUDIT.getCode());
            actionType = tsProjectSimple.getId() == null ? ActionTypeEnum.WORK_START_TYPE : ActionTypeEnum.BIZ_LOG_TYPE;
        }
        try {
            tsProjectSimple = this.tsProjectSimpleService.saveInfo(tsProjectSimple, param);
            data.setResult((Object)tsProjectSimple);
            data.setContent("\u64cd\u4f5c\u6210\u529f");
            data.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent(e.getMessage());
            data.setState(ResponseStateEnum.fail);
        }
        if (Objects.equals(param.getEditType(), (byte)2)) {
            this.baseController.passKeyFactorAuditIfTrainBase(UserUtils.getCurrentCompany(), UserUtils.getLoginStaff(), tsProjectSimple.getId());
        }
        request.setAttribute("keyFactoryId", (Object)tsProjectSimple.getKeyFactoryId());
        request.setAttribute("actionType", (Object)actionType.getValue());
        return data;
    }

    @PostMapping(value={"/closed"})
    @ResponseBody
    @RequiresPermissions(value={"thirdtime.edit"})
    public ResponseData closed(Long id) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        data.setContent("\u9879\u76ee\u4e0d\u80fd\u7ec8\u6b62");
        return data;
    }

    @PostMapping(value={"/superviseBack"})
    @ResponseBody
    public ResponseData superviseBack(Long id) {
        ResponseData data = new ResponseData();
        try {
            String superviseFullName = String.valueOf(this.session.getAttribute("superviseFullName"));
            this.tsProjectSimpleService.superviseBack2Default(id, UserUtils.getLoginStaffId(), superviseFullName);
            data.setState(ResponseStateEnum.success);
            data.setContent("\u64cd\u4f5c\u6210\u529f");
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setState(ResponseStateEnum.fail);
            data.setContent(e.getMessage());
            return data;
        }
    }

    @Log(title="\u5173\u8054\u65b0\u5efa\u4f01\u4e1a\u4e09\u540c\u65f6\u9879\u76ee")
    @PostMapping(value={"/mergeNewCompanyGuideTsProject"})
    @ResponseBody
    public ResponseData<String> mergeNewCompanyGuideTsProject(Long projectId) {
        try {
            this.newCompanyGuideProgressService.manualRelatedTsProject(UserUtils.getLoginStaffCompanyId(), projectId);
        }
        catch (RuntimeException e) {
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success();
    }

    @Log(title="\u53d6\u6d88\u5173\u8054\u65b0\u5efa\u4f01\u4e1a\u4e09\u540c\u65f6\u9879\u76ee")
    @PostMapping(value={"/cancelNewCompanyGuideTsProject"})
    @ResponseBody
    public ResponseData<List<String>> cancelNewCompanyGuideTsProject(Long projectId) {
        try {
            this.newCompanyGuideProgressService.cancelRelatedTsProject(UserUtils.getLoginStaffCompanyId(), projectId);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success();
    }

    @Log(title="\u63d0\u4ea4\u65b0\u5efa\u4f01\u4e1a\u5173\u8054\u7684\u4e09\u540c\u65f6\u9879\u76ee")
    @PostMapping(value={"/submitNewCompanyGuideTsProject"})
    @ResponseBody
    public ResponseData<String> submitNewCompanyGuideTsProject(Long projectId) {
        try {
            CompanyBaseInfoModel companyBaseInfoModel = UserUtils.getCurrentCompanyFromDataCenter();
            Company company = new Company();
            BeanUtils.copyProperties((Object)Objects.requireNonNull(companyBaseInfoModel), (Object)company);
            this.tsProjectSimpleService.submitNewCompanyGuideTsProject(projectId, company, UserUtils.getLoginStaff());
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success();
    }

    @GetMapping(value={"/resetTsProject"})
    @ResponseBody
    @Log(title="\u5b9e\u8bad\u57fa\u5730-\u91cd\u7f6e\u4e09\u540c\u65f6")
    public ResponseData<String> resetTsProject() {
        this.tsProjectSimpleService.resetTsProject(UserUtils.getLoginStaffCompanyId());
        return ResponseData.success();
    }

    private void verify(EditParam param) {
        TsProjectSimpleStateEnum controlState;
        TsProjectSimpleStateEnum designState;
        boolean isAnyNotStarted;
        Date comparisonDate;
        boolean chooseCutoff;
        Boolean existFinishedProjects;
        param.setStatus(TsProjectSimpleStatusEnum.DRAFT.getCode());
        if (StringUtils.isEmpty((CharSequence)param.getProjectName())) {
            throw new RuntimeException("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getProjectTime() == null) {
            throw new RuntimeException("\u9879\u76ee\u7acb\u9879\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TsProjectSimple dbData = new TsProjectSimple();
        if (param.getId() != null) {
            dbData = (TsProjectSimple)this.tsProjectSimpleService.getById(param.getId());
        }
        if (!backReasonList.contains(dbData.getRemark())) {
            if (param.getDesignFinishTime() != null && param.getDesignFinishTime().before(param.getProjectTime())) {
                throw new RuntimeException("\u8bbe\u8ba1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7acb\u9879\u65f6\u95f4");
            }
            if (param.getDesignFinishTime() != null && param.getHarmEvalFinishTime1() != null && param.getDesignFinishTime().before(param.getHarmEvalFinishTime1())) {
                throw new RuntimeException("\u8bbe\u8ba1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u9884\u8bc4\u65f6\u95f4");
            }
            if (param.getDesignFinishTime() != null && param.getHarmEvalFinishTime2() != null && param.getDesignFinishTime().before(param.getHarmEvalFinishTime2())) {
                throw new RuntimeException("\u8bbe\u8ba1\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u9884\u8bc4\u65f6\u95f4");
            }
            if (param.getConFinishTime1() != null && param.getConFinishTime1().before(param.getProjectTime())) {
                throw new RuntimeException("\u63a7\u8bc4\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7acb\u9879\u65f6\u95f4");
            }
            if (param.getConFinishTime1() != null && param.getDesignFinishTime() != null && param.getConFinishTime1().before(param.getDesignFinishTime())) {
                throw new RuntimeException("\u63a7\u8bc4\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8bbe\u8ba1\u65f6\u95f4");
            }
            if (param.getConFinishTime2() != null && param.getConFinishTime2().before(param.getProjectTime())) {
                throw new RuntimeException("\u63a7\u8bc4\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7acb\u9879\u65f6\u95f4");
            }
            if (param.getConFinishTime2() != null && param.getDesignFinishTime() != null && param.getConFinishTime2().before(param.getDesignFinishTime())) {
                throw new RuntimeException("\u63a7\u8bc4\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8bbe\u8ba1\u65f6\u95f4");
            }
        }
        if ((TsProjectSimpleStateEnum.FINISH.getCode().equals(param.getEvalState()) || TsProjectSimpleStateEnum.FINISH.getCode().equals(param.getDesignState()) || TsProjectSimpleStateEnum.FINISH.getCode().equals(param.getControlState())) && param.getMissingItem() != null && param.getMissingItem() != 2) {
            throw new RuntimeException("\u6709\u5df2\u5b8c\u6210\u7684\u70b9\u51fb\u3010\u65e0\u9700\u5f00\u5c55\u4e09\u540c\u65f6\u9879\u76ee\u3011\uff0c\u53ea\u80fd\u9009\u672a\u5b9e\u9645\u5f00\u5c55\u5efa\u8bbe");
        }
        if (TsProjectSimpleStateEnum.FINISH.getCode().equals(param.getEvalState()) && TsProjectSimpleStateEnum.FINISH.getCode().equals(param.getDesignState()) && TsProjectSimpleStateEnum.FINISH.getCode().equals(param.getControlState()) && param.getRiskType() != null) {
            param.setIsComplete(Boolean.valueOf(true));
        }
        if (param.getId() != null) {
            if (!Objects.equals(UserUtils.getCurrentCompany().getId(), dbData.getCid())) {
                throw new RuntimeException("\u672c\u6b21\u767b\u5f55\u5df2\u5207\u6362\u8d26\u53f7\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u91cd\u65b0\u6253\u5f00\uff01");
            }
            param.setStatus(dbData.getStatus());
        }
        if (param.getEditType() == 1) {
            return;
        }
        if (TsProjectSimpleStateEnum.FINISH.getCode().equals(param.getEvalState()) && TsProjectSimpleStateEnum.FINISH.getCode().equals(param.getDesignState()) && TsProjectSimpleStateEnum.FINISH.getCode().equals(param.getControlState()) && param.getRiskType() == null) {
            throw new RuntimeException("\u8bf7\u586b\u5199\u804c\u4e1a\u75c5\u5371\u5bb3\u98ce\u9669\u7c7b\u522b");
        }
        if (param.getIsMissingItem().booleanValue()) {
            if (StringUtils.isEmpty((CharSequence)param.getEvidence())) {
                throw new RuntimeException("\u65e0\u9700\u5f00\u5c55\u9700\u8981\u4e0a\u4f20\u4f50\u8bc1\u6750\u6599");
            }
            if (Objects.isNull(param.getCommitment())) {
                throw new RuntimeException("\u65e0\u9700\u5f00\u5c55\u5fc5\u987b\u4e0a\u4f20\u627f\u8bfa\u4e66");
            }
        }
        if ((existFinishedProjects = this.tsProjectSimpleService.existFinishedProjects(UserUtils.getLoginStaffCompanyId(), DateUtil.getDate((String)"2023-07-01", (String)"yyyy-MM-dd"))).booleanValue() && param.getProjectTime().before(Objects.requireNonNull(DateUtil.getDate((String)"2023-07-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss")))) {
            param.setIsComplete(Boolean.valueOf(true));
            param.setRemark(TsProjectSimpleRemarkEnum.HAS_PROJECT_BEFORE_7_1.getCode().toString());
        } else if (!param.getIsComplete().booleanValue() && param.getCommitment() == null) {
            throw new RuntimeException("\u672a\u7ae3\u5de5\u9a8c\u6536\u9879\u76ee\u9700\u4e0a\u4f20\u627f\u8bfa\u4e66");
        }
        List companyList = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByCid(Collections.singletonList(UserUtils.getLoginStaffCompanyId()));
        Date storageDate = CollUtil.isEmpty((Collection)companyList) ? null : ((CompanySuperviseModel)companyList.get(0)).getGradeCreateDate();
        Date cutoffDate = DateUtil.getDate((String)"2023-07-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
        boolean bl = chooseCutoff = storageDate == null || storageDate.before(cutoffDate);
        if (!chooseCutoff) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = sdf.format(storageDate);
            try {
                storageDate = sdf.parse(dateStr);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
        Date date = comparisonDate = chooseCutoff ? cutoffDate : storageDate;
        if ((param.getProjectTime().equals(comparisonDate) || param.getProjectTime().after(comparisonDate)) && (isAnyNotStarted = Stream.of(param.getEvalState(), param.getDesignState(), param.getControlState()).anyMatch(state -> TsProjectSimpleStateEnum.NOT_START.getCode().equals(state)))) {
            String errorMessage = chooseCutoff ? "\u9879\u76ee\u7acb\u9879\u57282023\u5e747\u67081\u65e5\u4ee5\u540e\uff0c\u4e09\u540c\u65f6\u5c31\u4e0d\u5141\u8bb8\u9009\u201c\u672a\u5f00\u5c55\u201d" : String.format("\u9879\u76ee\u7acb\u9879\u5728\u5165\u5e93\u65f6\u95f4\uff08%s\uff09\u4ee5\u540e\uff0c\u4e09\u540c\u65f6\u5c31\u4e0d\u5141\u8bb8\u9009\u201c\u672a\u5f00\u5c55\u201d", new SimpleDateFormat("yyyy-MM-dd").format(storageDate));
            throw new ServiceException(errorMessage);
        }
        if (!param.getIsMissingItem().booleanValue()) {
            if (param.getEvalState() == null) {
                throw new RuntimeException("\u672a\u9009\u62e9\u804c\u4e1a\u75c5\u5371\u5bb3\u9884\u8bc4\u4ef7\u9636\u6bb5\u72b6\u6001\uff0c\u8bf7\u9009\u62e9\u540e\u63d0\u4ea4");
            }
            if (param.getDesignState() == null) {
                throw new RuntimeException("\u672a\u9009\u62e9\u804c\u4e1a\u75c5\u5371\u5bb3\u9632\u62a4\u8bbe\u65bd\u8bbe\u8ba1\u4e13\u7bc7\u9636\u6bb5\u72b6\u6001\uff0c\u8bf7\u9009\u62e9\u540e\u63d0\u4ea4");
            }
            if (param.getControlState() == null) {
                throw new RuntimeException("\u672a\u9009\u62e9\u804c\u4e1a\u75c5\u5371\u5bb3\u63a7\u5236\u6548\u679c\u8bc4\u4ef7\u9636\u6bb5\u72b6\u6001\uff0c\u8bf7\u9009\u62e9\u540e\u63d0\u4ea4");
            }
        }
        if ((TsProjectSimpleStateEnum.NOT_START.getCode().equals(param.getEvalState()) || TsProjectSimpleStateEnum.ING.getCode().equals(param.getEvalState())) && (param.getHarmEvalFinishTime1() != null || StringUtils.isNotEmpty((String)param.getHarmEvalOrgName1()) && !"/".equalsIgnoreCase(param.getHarmEvalOrgName1()) || param.getHarmEvalFinishTime2() != null || StringUtils.isNotEmpty((String)param.getHarmEvalOrgName2()) && !"/".equalsIgnoreCase(param.getHarmEvalOrgName2()))) {
            throw new RuntimeException("\u9884\u8bc4\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
        }
        if ((TsProjectSimpleStateEnum.NOT_START.getCode().equals(param.getDesignState()) || TsProjectSimpleStateEnum.ING.getCode().equals(param.getDesignState())) && (param.getDesignFinishTime() != null || StringUtils.isNotEmpty((String)param.getDesignOrgName()) && !"/".equalsIgnoreCase(param.getDesignOrgName()))) {
            throw new RuntimeException("\u8bbe\u8ba1\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
        }
        if ((TsProjectSimpleStateEnum.NOT_START.getCode().equals(param.getControlState()) || TsProjectSimpleStateEnum.ING.getCode().equals(param.getControlState())) && (StringUtils.isNotEmpty((String)param.getConEvalOrgName1()) && !"/".equalsIgnoreCase(param.getConEvalOrgName1()) || param.getConEvalOrgId1() != null || StringUtils.isNotEmpty((String)param.getConEvalOrgName2()) && !"/".equalsIgnoreCase(param.getConEvalOrgName2()) || param.getConEvalOrgId2() != null)) {
            throw new RuntimeException("\u63a7\u8bc4\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
        }
        if (TsProjectSimpleStateEnum.ING.getCode().equals(param.getEvalState()) && (param.getDesignState() != TsProjectSimpleStateEnum.NOT_YET.getCode() || param.getControlState() != TsProjectSimpleStateEnum.NOT_YET.getCode())) {
            throw new RuntimeException("\u9884\u8bc4\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\uff0c\u8bbe\u8ba1\u548c\u63a7\u8bc4\u4e0d\u80fd\u586b\u5199\u6570\u636e");
        }
        if (TsProjectSimpleStateEnum.ING.getCode().equals(param.getDesignState()) && param.getControlState() != TsProjectSimpleStateEnum.NOT_YET.getCode()) {
            throw new RuntimeException("\u8bbe\u8ba1\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\uff0c\u63a7\u8bc4\u4e0d\u80fd\u586b\u5199\u6570\u636e");
        }
        if ((TsProjectSimpleStateEnum.ING.getCode().equals(param.getEvalState()) || TsProjectSimpleStateEnum.ING.getCode().equals(param.getDesignState()) || TsProjectSimpleStateEnum.ING.getCode().equals(param.getControlState())) && param.getProjectFinishTime() != null) {
            throw new RuntimeException("\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u9879\uff0c\u7ae3\u5de5\u65f6\u95f4\u4e0d\u53ef\u586b\u5199");
        }
        TsProjectSimpleStateEnum evalState = TsProjectSimpleStateEnum.getEnum((Byte)param.getEvalState());
        if (evalState == TsProjectSimpleStateEnum.FINISH) {
            boolean noneEval2;
            boolean noneEval1Name = CharSequenceUtil.isBlank((CharSequence)param.getHarmEvalOrgName1());
            boolean noneEval1Time = param.getHarmEvalFinishTime1() == null;
            boolean noneEval1File = CharSequenceUtil.isBlank((CharSequence)param.getEvalEvidenceId1());
            boolean noneEval2Name = CharSequenceUtil.isBlank((CharSequence)param.getHarmEvalOrgName2());
            boolean noneEval2Time = param.getHarmEvalFinishTime2() == null;
            boolean noneEval2File = CharSequenceUtil.isBlank((CharSequence)param.getEvalEvidenceId2());
            boolean bl2 = noneEval2 = noneEval2Name && noneEval2Time && noneEval2File;
            if (noneEval1Name) {
                throw new ServiceException("\u9884\u8bc4\uff1a\u8bc4\u4ef7\u673a\u6784\u672a\u5b8c\u5584");
            }
            if (noneEval1Time) {
                throw new ServiceException("\u9884\u8bc4\uff1a\u8bc4\u4ef7\u65f6\u95f4\u672a\u5b8c\u5584");
            }
            if (noneEval1File) {
                throw new ServiceException("\u9884\u8bc4\uff1a\u4f50\u8bc1\u6750\u6599\u672a\u5b8c\u5584");
            }
            if (!noneEval2) {
                if (noneEval2Name) {
                    throw new ServiceException("\u9884\u8bc4\uff1a\u7b2c\u4e8c\u5bb6\u8bc4\u4ef7\u673a\u6784\u672a\u5b8c\u5584");
                }
                if (noneEval2Time) {
                    throw new ServiceException("\u9884\u8bc4\uff1a\u7b2c\u4e8c\u5bb6\u8bc4\u4ef7\u65f6\u95f4\u672a\u5b8c\u5584");
                }
                if (noneEval2File) {
                    throw new ServiceException("\u9884\u8bc4\uff1a\u7b2c\u4e8c\u5bb6\u4f50\u8bc1\u6750\u6599\u672a\u5b8c\u5584");
                }
            }
        }
        if ((designState = TsProjectSimpleStateEnum.getEnum((Byte)param.getDesignState())) == TsProjectSimpleStateEnum.FINISH) {
            boolean noneDesignName = CharSequenceUtil.isBlank((CharSequence)param.getDesignOrgName());
            boolean noneDesignTime = param.getDesignFinishTime() == null;
            boolean noneDesignFile = CharSequenceUtil.isBlank((CharSequence)param.getDesignEvidenceId());
            if (noneDesignName) {
                throw new ServiceException("\u8bbe\u8ba1\uff1a\u8bbe\u8ba1\u673a\u6784\u672a\u5b8c\u5584");
            }
            if (noneDesignTime) {
                throw new ServiceException("\u8bbe\u8ba1\uff1a\u8bbe\u8ba1\u65f6\u95f4\u672a\u5b8c\u5584");
            }
            if (noneDesignFile) {
                throw new ServiceException("\u8bbe\u8ba1\uff1a\u4f50\u8bc1\u6750\u6599\u672a\u5b8c\u5584");
            }
        }
        if ((controlState = TsProjectSimpleStateEnum.getEnum((Byte)param.getControlState())) == TsProjectSimpleStateEnum.FINISH) {
            boolean noneControl;
            boolean noneControl1Name = CharSequenceUtil.isBlank((CharSequence)param.getConEvalOrgName1());
            boolean noneControl1Time = param.getConFinishTime1() == null;
            boolean noneControl1File = CharSequenceUtil.isBlank((CharSequence)param.getControlEvidenceId1());
            boolean noneControl2Name = CharSequenceUtil.isBlank((CharSequence)param.getConEvalOrgName2());
            boolean noneControl2Time = param.getConFinishTime2() == null;
            boolean noneControl2File = CharSequenceUtil.isBlank((CharSequence)param.getControlEvidenceId2());
            boolean bl3 = noneControl = noneControl2Name && noneControl2Time && noneControl2File;
            if (noneControl1Name) {
                throw new ServiceException("\u63a7\u8bc4\uff1a\u8bc4\u4ef7\u673a\u6784\u672a\u5b8c\u5584");
            }
            if (noneControl1Time) {
                throw new ServiceException("\u63a7\u8bc4\uff1a\u8bc4\u4ef7\u65f6\u95f4\u672a\u5b8c\u5584");
            }
            if (noneControl1File) {
                throw new ServiceException("\u63a7\u8bc4\uff1a\u4f50\u8bc1\u6750\u6599\u672a\u5b8c\u5584");
            }
            if (!noneControl) {
                if (noneControl2Name) {
                    throw new ServiceException("\u63a7\u8bc4\uff1a\u7b2c\u4e8c\u5bb6\u8bc4\u4ef7\u673a\u6784\u672a\u5b8c\u5584");
                }
                if (noneControl2Time) {
                    throw new ServiceException("\u63a7\u8bc4\uff1a\u7b2c\u4e8c\u5bb6\u8bc4\u4ef7\u65f6\u95f4\u672a\u5b8c\u5584");
                }
                if (noneControl2File) {
                    throw new ServiceException("\u63a7\u8bc4\uff1a\u7b2c\u4e8c\u5bb6\u4f50\u8bc1\u6750\u6599\u672a\u5b8c\u5584");
                }
            }
            if (param.getRiskType() == null) {
                throw new RuntimeException("\u8bf7\u586b\u5199\u804c\u4e1a\u75c5\u5371\u5bb3\u98ce\u9669\u7c7b\u522b");
            }
        }
        if (param.getProjectFinishTime() != null) {
            if (param.getProjectFinishTime().after(new Date())) {
                throw new RuntimeException("\u7ae3\u5de5\u65f6\u95f4\u4e0d\u53ef\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
            }
            if (param.getProjectFinishTime().before(param.getProjectTime())) {
                throw new RuntimeException("\u7ae3\u5de5\u65f6\u95f4\u4e0d\u53ef\u65e9\u4e8e\u9879\u76ee\u5f00\u59cb\u65f6\u95f4");
            }
            if (param.getHarmEvalFinishTime1() != null && param.getProjectFinishTime().before(param.getHarmEvalFinishTime1())) {
                throw new RuntimeException("\u7ae3\u5de5\u65f6\u95f4\u4e0d\u53ef\u65e9\u4e8e\u9884\u8bc4\u5f00\u59cb\u65f6\u95f4");
            }
            if (param.getHarmEvalFinishTime2() != null && param.getProjectFinishTime().before(param.getHarmEvalFinishTime2())) {
                throw new RuntimeException("\u7ae3\u5de5\u65f6\u95f4\u4e0d\u53ef\u65e9\u4e8e\u9884\u8bc4\u5f00\u59cb\u65f6\u95f4");
            }
            if (param.getDesignFinishTime() != null && param.getProjectFinishTime().before(param.getDesignFinishTime())) {
                throw new RuntimeException("\u7ae3\u5de5\u65f6\u95f4\u4e0d\u53ef\u65e9\u4e8e\u8bbe\u8ba1\u5f00\u59cb\u65f6\u95f4");
            }
            if (param.getConFinishTime1() != null && param.getProjectFinishTime().before(param.getConFinishTime1())) {
                throw new RuntimeException("\u7ae3\u5de5\u65f6\u95f4\u4e0d\u53ef\u65e9\u4e8e\u63a7\u8bc4\u5f00\u59cb\u65f6\u95f4");
            }
            if (param.getConFinishTime2() != null && param.getProjectFinishTime().before(param.getConFinishTime2())) {
                throw new RuntimeException("\u7ae3\u5de5\u65f6\u95f4\u4e0d\u53ef\u65e9\u4e8e\u63a7\u8bc4\u5f00\u59cb\u65f6\u95f4");
            }
        }
    }

    private void setSearchParam(SearchParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        if (param.getClosed() != null && param.getClosed().booleanValue()) {
            param.setStatusList(Collections.singletonList(TsProjectSimpleStatusEnum.CLOSED.getCode()));
        } else if (param.getFinish() != null) {
            if (param.getFinish().booleanValue()) {
                param.setStatusList(Arrays.asList(TsProjectSimpleStatusEnum.AUDITED.getCode(), TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode()));
            } else {
                param.setStatusList(Arrays.asList(TsProjectSimpleStatusEnum.DRAFT.getCode(), TsProjectSimpleStatusEnum.AUDIT.getCode(), TsProjectSimpleStatusEnum.BACK.getCode(), TsProjectSimpleStatusEnum.PROJECT_MANDATORY_ANNUAL_UPDATE.getCode()));
            }
        }
    }
}

