/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.thirdtime.simple;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectPhraseEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectTypeEnum;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/thirdtime/tsproject/simple"})
public class TsProjectSimpleController
extends ControllerSupport {
    @DubboReference
    private ITsProjectSimpleService tsProjectSimpleService;

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"toAddOrEditPage"}, method={RequestMethod.GET})
    public String toAddOrEditPage(ModelMap m, Long id, String action) {
        TsProjectSimple tsProjectSimple = null;
        if ("edit".equals(action)) {
            tsProjectSimple = (TsProjectSimple)this.tsProjectSimpleService.getById(id);
        }
        if (tsProjectSimple == null) {
            tsProjectSimple = new TsProjectSimple();
        }
        m.put((Object)"tsProjectSimple", (Object)tsProjectSimple);
        return "work/thirdtime/dialog/addedit";
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"index"})
    @Log(title="\u7b80\u5316\u7248\u4e09\u540c\u65f6-\u5efa\u8bbe\u9879\u76ee\u4e09\u540c\u65f6\u7ba1\u7406", type=2)
    public String page_finish(ModelMap m, Integer year, Byte eTypeStrs) {
        m.put((Object)"tsprojecttype", (Object)JsonMapper.toJsonString((Object)TsProjectTypeEnum.getAllValues()));
        m.put((Object)"tsprojectPhrase", (Object)JsonMapper.toJsonString((Object)TsProjectPhraseEnum.getAllValues()));
        m.put((Object)"year", (Object)year);
        m.put((Object)"eTypeStrs", (Object)eTypeStrs);
        return "work/thirdtime/simple/index";
    }

    @RequestMapping(value={"/indexlistData"})
    @ResponseBody
    public JqGridData<TsProjectSimple> indexlistData(JqGridParam param, Integer year, Byte eTypeStrs) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.tsProjectSimpleService.pageTsProjectSimple(param, year, eTypeStrs);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"thirdtime.edit"})
    @Log(title="\u4fdd\u5b58\u4e09\u540c\u65f6\u7b80\u5316\u7248\u4fe1\u606f", type=20)
    @RequestMapping(value={"save"})
    @ResponseBody
    public ResponseData<TsProjectSimple> saveWorkSource(TsProjectSimple ts) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long orgId = UserUtils.getOrgId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData resultData = new ResponseData();
        try {
            if (StringUtils.isEmpty((CharSequence)ts.getOrgId())) {
                ts.setOrgId("" + UserUtils.getOrgId());
            }
            ts = this.tsProjectSimpleService.saveOrUpdateTsProject(ts, loginStaffId, cid);
            resultData.setResult((Object)ts);
            resultData.setContent("\u4fdd\u5b58\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @RequiresPermissions(value={"thirdtime.edit"})
    @Log(title="\u5220\u9664\u4e09\u540c\u65f6\u7b80\u5316\u7248", type=22)
    @RequestMapping(value={"delThirdtime"})
    @ResponseBody
    public ResponseData<TsProjectSimple> delThirdtime(TsProjectSimple ts) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        ResponseData resultData = new ResponseData();
        try {
            ts.setCid(cid);
            this.tsProjectSimpleService.delTsProject(ts, loginStaffId);
            resultData.setContent("\u5220\u9664\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @RequestMapping(value={"/getCountForVisualize"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData getCountForVisualize() {
        ResponseData responseData = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map map = this.tsProjectSimpleService.getCountForVisualize(cid);
        responseData.setResult((Object)map);
        return responseData;
    }
}

