/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.thirdtime;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessTypeEnum;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearExecute;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProject;
import cn.smarthse.modules.health.entity.work.thirdtime.vo.TsProjectVo;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectPhraseEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectTypeEnum;
import cn.smarthse.modules.health.service.work.thirdtime.ITsProjectService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SyncBusinessUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/thirdtime/tsproject"})
public class TsProjectController
extends ControllerSupport {
    @DubboReference
    private ITsProjectService tsProjectService;

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping
    @Log(title="\u4e09\u540c\u65f6-\u9996\u9875", type=2)
    public String page_index(ModelMap m) {
        m.put((Object)"tsprojecttype", (Object)JsonMapper.toJsonString((Object)TsProjectTypeEnum.getAllValues()));
        m.put((Object)"tsprojectPhrase", (Object)JsonMapper.toJsonString((Object)TsProjectPhraseEnum.getAllValues()));
        return "work/thirdtime/index-default";
    }

    @RequiresPermissions(value={"thirdtime.edit"})
    @GetMapping(value={"import"})
    public String import_page() {
        return "work/thirdtime/dialog/addedit";
    }

    @RequiresPermissions(value={"recordFile.1.view"})
    @RequestMapping(value={"previewDoc"})
    @Log(title="\u4e09\u540c\u65f6-\u6863\u6848\u9884\u89c8", type=2)
    public String previewDoc(ModelMap m, String tsProId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map docData = this.tsProjectService.getDocData(cid, tsProId);
        m.putAll(docData);
        return "work/thirdtime/previewDoc";
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"finish"})
    @Log(title="\u4e09\u540c\u65f6-\u5df2\u5b8c\u6210\u5217\u8868", type=2)
    public String page_finish(ModelMap m) {
        m.put((Object)"tsprojecttype", (Object)JsonMapper.toJsonString((Object)TsProjectTypeEnum.getAllValues()));
        m.put((Object)"tsprojectPhrase", (Object)JsonMapper.toJsonString((Object)TsProjectPhraseEnum.getAllValues()));
        return "work/thirdtime/finish";
    }

    @RequestMapping(value={"goto/{page}"})
    public String openPage(@PathVariable(value="page") String page) {
        return "work/thirdtime/" + page;
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"addTsprojectPage"})
    @Log(title="\u4e09\u540c\u65f6-\u6dfb\u52a0\u9875\u9762", type=2)
    public String addTsprojectPage(ModelMap m) {
        if (UserUtils.isLiteVersion()) {
            List collect = Arrays.stream(TsProjectPhraseEnum.values()).filter(model -> model.getCode() != 4 && model.getCode() != 6).collect(Collectors.toList());
            m.put((Object)"projectPhrase", collect);
        } else {
            m.put((Object)"projectPhrase", (Object)TsProjectPhraseEnum.values());
        }
        m.put((Object)"projectType", (Object)TsProjectTypeEnum.values());
        return "work/thirdtime/addtsproject";
    }

    @RequestMapping(value={"/listData"})
    @ResponseBody
    public JqGridData<TsProjectVo> listData(JqGridParam param, Boolean finish) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.tsProjectService.pageTsProject(param, finish);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequestMapping(value={"/finishlistData"})
    @ResponseBody
    public JqGridData<TsProjectVo> finishlistData(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.tsProjectService.pageTsProject(param, Boolean.valueOf(true));
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"thirdtime.edit"})
    @Log(title="\u4fdd\u5b58\u4e09\u540c\u65f6\u4fe1\u606f", type=20)
    @RequestMapping(value={"save"})
    @RepeatUrlFormData
    @ResponseBody
    public ResponseData<TsProject> saveWorkSource(TsProject ts) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long orgId = UserUtils.getOrgId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData resultData = new ResponseData();
        try {
            if (StringUtils.isEmpty((CharSequence)ts.getOrgId())) {
                ts.setOrgId("" + UserUtils.getOrgId());
            }
            ts = this.tsProjectService.saveOrUpdateTsProject(ts, loginStaffId, cid);
            resultData.setResult((Object)ts);
            resultData.setContent("\u4fdd\u5b58\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @Log(title="\u5220\u9664\u4e09\u540c\u65f6", type=22)
    @RequestMapping(value={"delThirdtime"})
    @RequiresPermissions(value={"thirdtime.edit"})
    @RepeatUrlFormData
    @ResponseBody
    public ResponseData<TsProject> delThirdtime(TsProject ts) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        ResponseData resultData = new ResponseData();
        try {
            ts.setCid(cid);
            this.tsProjectService.delTsProject(ts, loginStaffId);
            if (ts != null && ts.getId() != null) {
                PlanYearExecute planYearExecute = new PlanYearExecute();
                planYearExecute.setBusinessId(ts.getId());
                planYearExecute.setBusinessType(BusinessTypeEnum.tsProject.getCode());
                planYearExecute.setCid(ts.getCid());
                planYearExecute.setImplState(PlanYearDetailImplState.unimplemented);
                SyncBusinessUtil.executeUpdatePlanYearDetail(planYearExecute);
            }
            resultData.setContent("\u5220\u9664\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @Log(title="\u4f5c\u5e9f\u4e09\u540c\u65f6", type=22)
    @RequestMapping(value={"toVoidThirdtime"})
    @RequiresPermissions(value={"thirdtime.edit"})
    @RepeatUrlFormData
    @ResponseBody
    public ResponseData<TsProject> toVoidThirdtime(TsProject ts) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData resultData = new ResponseData();
        try {
            this.tsProjectService.toVoidTsProject(ts, loginStaffId);
            resultData.setContent("\u4f5c\u5e9f\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u4f5c\u5e9f\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @Log(title="\u5df2\u5b8c\u6210\u5efa\u8bbe\u9879\u76ee\u6e05\u5355\u5bfc\u51fa", type=24)
    @RequestMapping(value={"/exportFinishTspro"})
    public void exportFinish(JqGridParam param, HttpServletResponse response) throws Exception {
        this.logger.info("\u5df2\u5b8c\u6210\u5efa\u8bbe\u9879\u76ee\u6e05\u5355\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5df2\u5b8c\u6210\"\u4e09\u540c\u65f6\"\u5de5\u4f5c\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u9879\u76ee\u7f16\u53f7|projectNo", "\u9879\u76ee\u540d\u79f0|projectName", "\u9879\u76ee\u6027\u8d28|projectTypeName", "\u9879\u76ee\u8d1f\u8d23\u4eba|leaderName", "\u9879\u76ee\u5f00\u59cb\u65f6\u95f4|beginTime", "\u9879\u76ee\u5b8c\u6210\u65f6\u95f4|finishTime"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        List tsproVoList = this.tsProjectService.listTsProjectVo(cid, Boolean.valueOf(true));
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport3("\u5df2\u5b8c\u6210\u5efa\u8bbe\u9879\u76ee\u6e05\u5355\u5bfc\u51fa", colums, tsproVoList, (OutputStream)response.getOutputStream());
    }
}

